<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Interesttype;

class InteresttypeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Interesttype = Interesttype::paginate(5);

        return view('asset-mgt/interesttype/index', ['Interesttype' => $Interesttype]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('asset-mgt/interesttype/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         Interesttype::create([
            'interesttype' => $request['interesttype']
        ]);

        return redirect()->intended('asset-mgt/interesttype');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Interesttypes = Interesttype::find($id);
        return view('asset-mgt/interesttype/edit', compact('Interesttypes', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Interesttypes = Interesttype::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'interesttype' => $request['interesttype']
        ];
        Interesttype::where('id', $id)
            ->update($input);
        
        return redirect()->intended('asset-mgt/interesttype')->with('success','Record update');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Interesttype::where('id', $id)->delete();
         return redirect()->intended('asset-mgt/interesttype');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'interesttype' => $request['interesttype']
            ];

       $interesttype = $this->doSearchingQuery($constraints);
       return view('asset-mgt/interesttype/index', ['Interesttype' => $Interesttype, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = Interesttype::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'interesttype' => 'required|max:60|unique:interesttypes'
    ]);
    }
}
