<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Interestratetype;

class InterestratetypeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Interestratetype = Interestratetype::paginate(5);

        return view('asset-mgt/interestratetype/index', ['Interestratetype' => $Interestratetype]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('asset-mgt/interestratetype/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         Interestratetype::create([
            'interestratetype' => $request['interestratetype']
        ]);

        return redirect()->intended('asset-mgt/interestratetype');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Interestratetypes = Interestratetype::find($id);
        return view('asset-mgt/interestratetype/edit', compact('Interestratetypes', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Interestratetypes = Interestratetype::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'interestratetype' => $request['interestratetype']
        ];
        Interestratetype::where('id', $id)
            ->update($input);
        
        return redirect()->intended('asset-mgt/interestratetype')->with('success','Record update');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        interestratetype::where('id', $id)->delete();
         return redirect()->intended('asset-mgt/interestratetype');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'interestratetype' => $request['interestratetype']
            ];

       $interestratetype = $this->doSearchingQuery($constraints);
       return view('asset-mgt/interestratetype/index', ['Interestratetype' => $Interestratetype, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = interestratetype::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'interestratetype' => 'required|max:60|unique:interestratetypes'
    ]);
    }
}
