<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Interestconverter;

class InterestconverterController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $interestconverter = Interestconverter::paginate(5);

        return view('asset-mgt/intconverter/index', ['interestconverter' => $interestconverter]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         return view('asset-mgt/intconverter/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $int_amount_P = $request->int_amount_P;

        $int_amount_I = ($request->int_amount_P/100)/364;


        $interestconverter = new interestconverter;

        $interestconverter->int_amount_P = $request->int_amount_P;
        $interestconverter->int_amount_I = $int_amount_I;
        

        $interestconverter->save();

        return redirect('asset-mgt/intconverter')->with('success','calculation Saved Successful');

    }
    

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $interestconverters = interestconverter::find($id);
        
            return view('asset-mgt/intconverter/edit', compact('interestconverters', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $int_amount_P = $request->int_amount_P;

        $int_amount_I = ($request->int_amount_P/100)/364;


        $interestconverter = interestconverter::find($id);

        $interestconverter->int_amount_P = $request->get('int_amount_P');
        $interestconverter->int_amount_I = $int_amount_I;

        $interestconverter->save();
        
        return redirect()->intended('asset-mgt/intconverter');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        interestconverter::where('id', $id)->delete();
         return redirect()->intended('asset-mgt/intconverter');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'int_amount_P' => $request['int_amount_P']
            ];

       $interestconverter = $this->doSearchingQuery($constraints);
       return view('asset-mgt/intconverter/index', ['interestconverter' => $interestconverter, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = interestconverter::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
}

    private function validateInput($request) {
        $this->validate($request, [
        'int_amount_P' => 'required|unique:interestconverters'
    ]);
    }
}
