<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use App\Models\Employee;
use App\Models\ClaimType;
use App\Models\Interestcalculator;
use App\Models\client_contribution;
use App\Models\interest;
use App\Models\csv_data;
use Carbon\Carbon;
use App\Modles\totaltransaction;
use App\Models\tbillsint;



class InterestcalculatorController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $totaltransaction = totaltransaction::all();
        $employees = Employee::all();
        $client_contribution= client_contribution::all();
        $Interestcalculator = DB::table('interestcalculators')
        ->leftJoin('tbillsints', 'interestcalculators.tbillsint_id', '=', 'tbillsints.id')
        ->select('interestcalculators.*', 'tbillsints.tbillsint_amount as tbillsint_amount', 'tbillsints.id as tbillsint_id')
        ->paginate(20);
        
        

        //return  ['Retirement_death' => $Retirement_death];

        return view('intcalculator/index', ['Interestcalculator' => $Interestcalculator]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $tbillsint = tbillsint::all();
        $Interestcalculator = Interestcalculator::all();
        return view('intcalculator/create',['tbillsint' => $tbillsint]);
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $date_of_commencement = $request->date_of_commencement;
        $date_of_completion = $request->date_of_completion;


        // diff btn dates

        
       $number_of_days_run = Carbon::parse($date_of_commencement)->diffInDaysFiltered(function(Carbon $date) {
            return $date->subDay();
         }, $date_of_completion);


       
        // loop through all the selected users
        $membersArray = $request->agree;
        foreach($membersArray as $staffNo){

           // Get the contribution of from the contribution table by the staffNo
            // this return the row of the given staff [name, contribution_amount, ]

            // $contributionRow = client_contribution::where('staff_no', '=', $staffNo)->first();
         $contributionRow = client_contribution::where('staff_no','=', $staffNo)
            ->where('contribution_month', '=', $request->intMonth)
            ->where('year', '=', $request->intYear)
            ->select('contribution_month as month', 'contribution_amount as amount', 'staff_no', 'name', 'year')
            ->get();


            // dd($contributionRow);

            $tbillsRecord = tbillsint::find($request->tbillsint_id);

           /* $interest_accrued = $request->tbills*$contributionRow[0]->amount*$tbillsRecord->tbillsint_amount * $tbillsRecord->tbillsint_amount/$tbillsRecord->tbillsint_amount ;*/


           $interest_accrued = $request->tbills*$contributionRow[0]->amount*1;



        $total_amount = $interest_accrued+$contributionRow[0]->amount;

       // $maturity_days = $maturity_days;

        

        $Interestcalculator = new Interestcalculator;

        $Interestcalculator->staff_no = $contributionRow[0]->staff_no;
        $Interestcalculator->name = $contributionRow[0]->name;
        $Interestcalculator->incident_date = $request->incident_date;
        $Interestcalculator->contribution_amount = $contributionRow[0]->amount;
        $Interestcalculator->tbills = $request->tbills;
        $Interestcalculator->tbillsint_id = $request->tbillsint_id;
        $Interestcalculator->interest_accrued = $interest_accrued;
        $Interestcalculator->contribution_month= $contributionRow[0]->month;
        $Interestcalculator->year = $contributionRow[0]->year;
        $Interestcalculator->total_amount = $total_amount;
        $Interestcalculator->date_of_commencement =$request->date_of_commencement;
        $Interestcalculator->date_of_completion = $request->date_of_completion;
        $Interestcalculator->number_of_days_run = $number_of_days_run;
       // $Interestcalculator->maturity_days = $maturity_days;
        

        $Interestcalculator->save();

    
        $this->creditAccount($Interestcalculator['staff_no'], $Interestcalculator['total_amount']);

    }


    //  $totaltransaction->save();

     



        return redirect('intcalculator')->with('success','Data Saved Successful');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Interestcalculators = Interestcalculator::find($id);
        // Redirect to state list if updating state wasn't existed
        if ($Interestcalculators == null) {
            return redirect()->intended('/intcalculator');
        }

        $tbillsint = tbillsint::all();
        
        return view('intcalculator/edit', ['Interestcalculators' => $Interestcalculators, 'tbillsints' => $tbillsints])->with('success','Record update');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
       
        //  return $request->all();

        $date_of_commencement = $request->date_of_commencement;
        $date_of_completion = $request->date_of_completion;


        // diff btn dates

        
       $number_of_days_run = Carbon::parse($date_of_commencement)->diffInDaysFiltered(function(Carbon $date) {
            return $date;
         }, $date_of_completion);

       


        // loop through all the selected users
        $membersArray = $request->agree;
        foreach($membersArray as $staffNo){

           // Get the contribution of from the contribution table by the staffNo
            // this return the row of the given staff [name, contribution_amount, ]

        $contributionRow = client_contribution::where('staff_no', '=', $staffNo)->first();


        $interest_accrued = $request->tbills*$contributionRow->contribution_amount * 1;

        $total_amount = $interest_accrued+$contributionRow->contribution_amount;
       

        

        $Interestcalculator = Interestcalculator::find($id);

        $Interestcalculator->staff_no = $contributionRow->get('staff_no');
        $Interestcalculator->name = $contributionRow->get('name');
        $Interestcalculator->incident_date = $request->get('incident_date');
        $Interestcalculator->contribution_amount = $contributionRow->get('contribution_amount');
        $Interestcalculator->tbills = $request->get('tbills');
        $Interestcalculator->interest_accrued = $interest_accrued;
        $Interestcalculator->contribution_month= $contributionRow->get('contribution_month');
        $Interestcalculator->year = $contributionRow->get('year');
        $Interestcalculator->total_amount = $total_amount;
        $Interestcalculator->date_of_commencement =$request->get('date_of_commencement');
        $Interestcalculator->date_of_completion = $request->get('date_of_completion');
        $Interestcalculator->number_of_days_run = $get('number_of_days_run');
        $Interestcalculator->tbillsint_id = $request->get('tbillsint_id');
       

        $Interestcalculator->save();


        }

       
      


        return redirect('intcalculator')->with('success','Data Saved Successful');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Interestcalculator::where('id', $id)->delete();
         return redirect()->intended('intcalculator');
    }



    public function search(Request $request) {

       $constraints = [
            'contribution_month' => $request['contribution_month'],
            'year' => $request['year'],
        ];

        
        // dd($constraints);

        

        $client_contributions = $this->getmonthclient_contribution($constraints);

        $tbillsint = tbillsint::all();
        return view('intcalculator/create', ['client_contribution' => $client_contributions, 'searchingVals' => $constraints, 'tbillsint' => $tbillsint]);

    }

    private function getmonthclient_contribution($constraints) {
        $client_contributionobj = client_contribution::where('contribution_month', '=', $constraints['contribution_month'])
                        ->where('year', '=', $constraints['year']);
        if (auth()->user()->user_type !== 'admin') {
            $client_contributionobj->where('email',auth()->user()->email);
        }               
       $client_contribution = $client_contributionobj->get();

        return $client_contribution;



       }

    private function getExportingData($constraints) {
        $client_contributionobj =  DB::table('client_contributions')
        ->select('client_contributions.staff_no', 'client_contributions.name', 'client_contributions.contribution_month', 'client_contributions.contribution_amount', 'client_contributions.year') 
        ->where('contribution_month', '=', $constraints['contribution_month'])
        ->where('year', '=', $constraints['year']);
        
        if (auth()->user()->user_type !== 'admin') {
            $client_contributionobj->where('email',auth()->user()->email);
        }               

       $client_contribution =  $client_contributionobj->get()
        ->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();

        return $client_contribution;

    }

    
    

    public function search_1(Request $request) {
$constraints = [
            'staff_no' => $request['staff_no']
        
            ];


       $Interestcalculator = $this->doSearchingQuery1($constraints);

       $tbillsint = tbillsint::all();

       return view('intcalculator/index', ['Interestcalculator' => $Interestcalculator, 'tbillsint' => $tbillsint, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery1($constraints) {

        $query = DB::table('interestcalculators')
        ->leftJoin('tbillsints', 'interestcalculators.tbillsint_id', '=', 'tbillsints.id')
        ->select('interestcalculators.*', 'tbillsint_amount as tbillsint_amount');

        $tbillsint = tbillsint::all();
        $query = Interestcalculator::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }

      //  dd($tbillsint);

        return $query->paginate(5);
    }

    private function validateInput($request) {
        $this->validate($request, [
        'staff_no' => 'required',
        'name' => 'required',
        'incident_date' => 'required',
        'contribution_amount' => 'required',
        'tbills' => 'required',
        'interest_accrued' => 'required',
        'contribution_month'=> 'required',
        'year' => 'required',
        'total_amount' => 'required',
        'date_of_commencement' => 'required',
        'date_of_completion' => 'required',
        'number_of_days_run' => 'required',
        'maturity_days' => 'required',
        'tbillsint_id' => 'required',
       

    ]);
    }

        private function createQueryInput($keys, $request) {
        $queryInput = [];
        for($i = 0; $i < sizeof($keys); $i++) {
            $key = $keys[$i];
            $queryInput[$key] = $request[$key];
        }

        return $queryInput;
    }


    // this will increase client total contributino on any payment made
    private function creditAccount($staff_no, $total_amount) {
     // $totalcontibutions = $employee->clientContributions()->sum('contribution_amount');

      //check if data exists

       $contAmount = DB::table('totaltransactions')->where('staff_no', $staff_no) ->first();
 
       if($contAmount) {
           
            DB::table('totaltransactions')->where('staff_no', $staff_no)->increment('total_amount',$total_amount);
       } else {
           
            DB::table('totaltransactions')->insert(['staff_no'=>$staff_no], ['total_amount'=>$total_amount]);

    }


}

// read csv actual data
 //   public function updateContribution(Request $request) {

        // Parse data from file line by line
       
    //    {
   //         //validate data
   //         $newContribution = new interestcalculators();
    //        $newContribution->staff_no = $getData[0];
   //         $newContribution->name = $getData[1];
   //         $newContribution->interest_accrued = $getData[2];
   //         $newContribution->total_amount = $getData[3];
  //          $newContribution->contribution_month = $getData[4];
    //        $newContribution->contribution_amount = $getData[5];
    //        $newContribution->tbills = $getData[6];
    //        $newContribution->incident_date = $getData[7];
    //        $newContribution->date_of_commencement = $getData[8];
    //        $newContribution->date_of_completion = $getData[9];
    //        $newContribution->number_of_days_run = $getData[10];
     //       $newContribution->year = $getData[11];
     //       $newContribution->save();

        //    // recod balance
        //    $this->creditAccount($getData[0], $getData[3]);

      //  }
      //  return view('import/import_success');
    //}

}


