<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\interest;

class InterestController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $interest = interest::paginate(5);

        return view('system-mgmt/interest/index', ['interest' => $interest]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/interest/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, array(
            'interest_amount' => 'required',
            ));

        $interest = new interest;

        $interest->interest_amount = $request->interest_amount;

        $interest->save();

        return redirect()->intended('system-management/interest')->with('Success', 'Data Added Successfuly');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $interests = interest::find($id);
        
            return view('system-mgmt/interest/edit', compact('interests', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
         $interets = interest::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'interest_amount' => $request['interest_amount']
        ];
        interest::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/interest');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        interest::where('id', $id)->delete();
         return redirect()->intended('system-management/interest');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'interest_amount' => $request['interest_amount']
            ];

       $interest = $this->doSearchingQuery($constraints);
       return view('system-mgmt/interest/index', ['interest' => $interest, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = interest::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
}

    private function validateInput($request) {
        $this->validate($request, [
        'interest_amount' => 'required|unique:interests'
    ]);
    }
}
