<?php

namespace App\Http\Controllers;

use App\Models\client_contribution;
use App\Models\Employee;
use App\Models\sex;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use App\Models\Pictureupload; 
use App\Models\Dailyinterestcalculator;
use App\Models\Transaction;
use Carbon\Carbon;
use App\Models\Indivinterestrpt;


class IndivinterestrptController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Transaction = Transaction::all();

        // Get the currently authenticated client
        $user = Auth::user();

        // Retrieve the client's interest contributions
        $Dailyinterestcalculator = Dailyinterestcalculator::where('clientaccount_number', $user->clientaccount_number)
        ->orderBy('incident_date', 'asc')
        ->get();

        // Calculate the sum of contribution_amount
        $total1 = $Dailyinterestcalculator->sum('maturityvalue_amount');
        $total = $Dailyinterestcalculator->sum('interestonmaturity_amount');
        $total2 = $Dailyinterestcalculator->sum('contribution_amount');

        // Pass contributions data and total contribution to the view
        return view('reports/individualclientdailyint/indivinterest-report/index', [
            'total' => $total, 'total1' => $total1, 'total2' => $total2, 'Transaction' => $Transaction, 'Dailyinterestcalculator' => $Dailyinterestcalculator
        ]);
    }

public function exportPDF1()
{
    // Get the currently authenticated client
        $user = Auth::user();

        // Retrieve the client's contributions
        $Dailyinterestcalculator = Dailyinterestcalculator::where('clientaccount_number', $user->clientaccount_number)->get();

        $pictureupload = Pictureupload::first();
        $Dailyinterestcalculator = Dailyinterestcalculator::first();
        $client_contribution = client_contribution::first();
        $Transaction = Transaction::first();
        

        // Calculate the sum of contribution_amount
        $total1 = $Dailyinterestcalculator->sum('maturityvalue_amount');
        $total = $Dailyinterestcalculator->sum('interestonmaturity_amount');
        $total2 = $Dailyinterestcalculator->sum('contribution_amount');

        // Load the PDF view
        $pdf = PDF::loadView('reports/individualclientdailyint/indivinterest-report.pdf', [
            'client_contribution' => $client_contribution,
            'total' => $total, 'total1' => $total1, 'total2' => $total2, 'pictureuploads' => $pictureupload, 'employee' => $employee, 'Dailyinterestcalculator' => $Dailyinterestcalculator, 'Transaction' => $Transaction
        ]);

        // Return the PDF for streaming or download
        return $pdf->stream('singleclient_report.pdf');

}

public function exportPDF2() 
{
    $user = Auth::user();

    // Retrieve the client's contributions
    $employee = Employee::where('clientaccount_number', $user->clientaccount_number)->get();

    $pictureupload = Pictureupload::first();
    $client_contribution = client_contribution::first();
    $Transaction = Transaction::first();

    // dd($employee);

        // Calculate the sum of contribution_amount
    $Dailyinterestcalculator = Dailyinterestcalculator::where('clientaccount_number', $user->clientaccount_number)->get();

        $total1 = $Dailyinterestcalculator->sum('maturityvalue_amount');
        $total = $Dailyinterestcalculator->sum('interestonmaturity_amount');
        $total2 = $Dailyinterestcalculator->sum('contribution_amount');

      //  dd($Dailyinterestcalculator);

    $pdf = PDF::loadView('reports/individualclientdailyint/pdf', [
        'Dailyinterestcalculator' => $Dailyinterestcalculator,
        'client_contribution' => $client_contribution,
        'pictureuploads' => $pictureupload,
        'Transaction' => $Transaction,
        'employee' => $employee,
        'total' => $total,
        'total1' => $total1,
        'total2' => $total2,
    ]);

    $pdf->setPaper('A4', 'portrait');



    return $pdf->stream('clientaccount_number' . '.pdf');
}

public function exportPDF()
{
$user = Auth::user();
    $clientaccount_number = $user->clientaccount_number;

    // Retrieve the client's contributions
    $employee = Employee::where('clientaccount_number', $clientaccount_number)->first();

    // Ensure that you have relevant data for the view
    $pictureupload = Pictureupload::first();
    $client_contribution = client_contribution::first();
    $Transaction = Transaction::first();

    // Retrieve Dailyinterestcalculator data
    $Dailyinterestcalculator = Dailyinterestcalculator::where('clientaccount_number', $clientaccount_number)
     ->orderBy('incident_date', 'asc')
        ->get();

    // Calculate the sum of contribution_amount
    $total1 = $Dailyinterestcalculator->sum('maturityvalue_amount');
    $total = $Dailyinterestcalculator->sum('interestonmaturity_amount');
    $total2 = $Dailyinterestcalculator->sum('contribution_amount');

    $pdf = PDF::loadView('reports/individualclientdailyint/indivinterest-report/pdf', [
        'Dailyinterestcalculator' => $Dailyinterestcalculator,
        'client_contribution' => $client_contribution,
        'pictureuploads' => $pictureupload,
        'Transaction' => $Transaction,
        'employee' => $employee,
        'total' => $total,
        'total1' => $total1,
        'total2' => $total2,
    ]);

    $pdf->setPaper('A4', 'portrait');

    return $pdf->stream($clientaccount_number . '.pdf');
}
    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
