<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\client_contribution;
use App\Models\Employee;
use App\Models\sex;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use App\Models\Pictureupload; 
use App\Models\Dailyinterestcalculator;
use App\Models\Transaction;
use Carbon\Carbon;
use App\Models\studentkyc;

class IndividualclientdailyintController extends Controller
{
     /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Transaction = Transaction::all();
        return view('reports/individualclientdailyint/index', ['Dailyinterestcalculator' => null, 'Transaction' => $Transaction, 'searchingVals' => ['clientaccount_number' => ''], 'total' => 0, 'total1' => 0, 'total2' => 0]);
    }

    public function exportExcel(Request $request) {
        $this->prepareExportingData($request)->export('xlsx');
        redirect()->intended('reports/individualclientdailyint');
    }

    public function exportPDF(Request $request) {
         $constraints = [
        'clientaccount_number' => $request->input('clientaccount_number'),
    ];


    $studentkyc = studentkyc::where('clientaccount_number', $request['clientaccount_number'])->first();
    $pictureupload = Pictureupload::first();
    $Dailyinterestcalculator = Dailyinterestcalculator::first();
    $client_contributions = client_contribution::first();
    $Transaction = Transaction::first();
    $employee = Employee::first();
  
  //dd($employee);
        
    $res = $this->getExportingData($constraints);
    $Dailyinterestcalculator = $res['Dailyinterestcalculator'];
    $sum = $res['sum'];
    $sum1 = $res['sum1'];
    $sum2 = $res['sum2'];

    $pdf = PDF::loadView('reports/individualclientdailyint/pdf', [
        'Dailyinterestcalculator' => $Dailyinterestcalculator,
        'client_contribution' => $client_contributions,
        'pictureuploads' => $pictureupload,
        'Transaction' => $Transaction,
        'searchingVals' => $constraints,
        'studentkyc' => $studentkyc,
        'employee' => $employee,
        'total' => $sum,
        'total1' => $sum1,
        'total2' => $sum2,
    ]);
    $pdf->setPaper('A4', 'portrait');
        
    return $pdf->stream($constraints['clientaccount_number'] . '.pdf');
}

    private function prepareExportingData($request) {
        $author = Auth::user()->username;
        $Dailyinterestcalculators = $this->getExportingData(['from'=> $request['clientaccount_number'], 'to' => $request['clientaccount_number']]);
        return Excel::create('report_from_'. $request['clientaccount_number'].'_to_'.$request['clientaccount_number'], function($excel) use($Dailyinterestcalculator, $request, $author) {

        // Set the title
        $excel->setTitle('Individual Daily Client Contributions from '. $request['from'].' to '. $request['to']);

        // Chain the setters
        $excel->setCreator($author)
            ->setCompany('Sic Financial Services Ltd');

        // Call them separately
        $excel->setDescription('Individual Daily Client Contributions');

        $excel->sheet('Individual Daily Client Contributions', function($sheet) use($Interestcalculators) {

        $sheet->fromArray($Interestcalculator);
            });
        });
    }

    public function search(Request $request) {
        $constraints = [
        'clientaccount_number' => $request->input('clientaccount_number'),
    ];

    $Transaction = Transaction::first();

    $res = $this->getclientaccount_numberInterestdailycalculator($constraints);
    $Dailyinterestcalculators = $res['Dailyinterestcalculator'];
    $sum = $res['sum'];
    $sum1 = $res['sum1'];
    $sum2 = $res['sum2'];

    return view('reports/individualclientdailyint/index')->with([
        'Dailyinterestcalculator' => $Dailyinterestcalculators,
        'searchingVals' => $constraints,
        'total' => $sum,
        'total1' => $sum1,
        'total2' => $sum2,
        'Transaction' => $Transaction,
    ]);
}

    private function getclientaccount_numberInterestdailycalculator($constraints) {

        $obj= Dailyinterestcalculator::where('clientaccount_number', '=', $constraints['clientaccount_number']);
                        
        $sum = $obj->sum('maturityvalue_amount');
        $sum1 = $obj->sum('interestonmaturity_amount');
        $sum2 = $obj->sum('contribution_amount');
        $Transaction = Transaction::all();
        $Dailyinterestcalculators = $obj->get();

        return ['sum' => $sum, 'sum1' => $sum1, 'sum2' => $sum2, 'Dailyinterestcalculator' =>  $Dailyinterestcalculators, 'Transaction' => $Transaction];

    }

    private function getExportingData($constraints) {
        $obj = DB::table('dailyinterestcalculators')
        ->leftJoin('transactions', 'dailyinterestcalculators.transaction_id', '=', 'transactions.id')
        ->select('dailyinterestcalculators.*','transaction_type as transaction_type');
        
        $obj->where('clientaccount_number', '=', $constraints['clientaccount_number']);
        $sum = $obj->sum('maturityvalue_amount');
        $sum1 = $obj->sum('interestonmaturity_amount');
        $sum2 = $obj->sum('contribution_amount');

        $Transaction = Transaction::first();
        $Dailyinterestcalculators = $obj->get();

        $Dailyinterestcalculators->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();

       return ['sum' => $sum, 'sum1' => $sum1, 'sum2' => $sum2, 'Dailyinterestcalculator' =>  $Dailyinterestcalculators, 'Transaction' => $Transaction];

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
