<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\client_contribution;
use App\Models\Employee;
use App\Models\sex;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use App\Models\Pictureupload; 
use App\Models\studentkyc;

class IndivclientrptController extends Controller
{

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $client_contributions = $this->getstaff_noclient_contribution();
      
        return view('import/indivclient-report/index', ['client_contribution' => null, 'searchingVals' => ['clientaccount_number' => ''], 'total' => 0]);
    }

    public function exportExcel(Request $request) {
        $this->prepareExportingData($request)->export('xlsx');
        redirect()->intended('import/indivclient-report');
    }

    public function exportPDF(Request $request) {
         $constraints = [
            'clientaccount_number' => $request['clientaccount_number'],
            
        ];

       // $employee = Employee::all();
      
        $studentkyc = studentkyc::where('clientaccount_number', '=', $constraints['clientaccount_number'])->first();
        $pictureupload = Pictureupload::first();
  //dd($employee);
  
        
        $res = $this->getExportingData($constraints);
        $client_contributions = $res['client_contribution'];
        $sum = $res['sum'];
        $pdf = PDF::loadView('import/indivclient-report/pdf', ['client_contribution' => $client_contributions, 'pictureuploads' => $pictureupload,  'searchingVals' => $constraints, 'studentkyc' => $studentkyc, 'total' => $sum]);
        
       // Mail::to('sdadzie@sic-fsl.com')->send(new statement($indivclientrpt));
        return $pdf->stream('statement'.'pdf');
        
    }
    
    private function prepareExportingData($request) {
        $author = Auth::user()->username;
        $client_contributions = $this->getExportingData(['from'=> $request['clientaccount_number'], 'to' => $request['clientaccount_number']]);
        return Excel::create('report_from_'. $request['clientaccount_number'].'_to_'.$request['clientaccount_number'], function($excel) use($client_contribution, $request, $author) {

        // Set the title
        $excel->setTitle('Individual Client Contributions from '. $request['from'].' to '. $request['to']);

        // Chain the setters
        $excel->setCreator($author)
            ->setCompany('SIC-FSL Ltd');

        // Call them separately
        $excel->setDescription('Individual Client Contributions');

        $excel->sheet('Individual Client Contributions', function($sheet) use($client_contributions) {

        $sheet->fromArray($client_contribution);
            });
        });
    }

    public function search(Request $request) {
        $constraints = [
            'clientaccount_number' => $request['clientaccount_number'],
            
        ];

        $res = $this->getclientaccount_numberclient_contribution($constraints);
        $client_contributions = $res['client_contribution'];
        $sum = $res['sum'];

        return view('import/indivclient-report/index')->with(['client_contribution' => $client_contributions, 'searchingVals' => $constraints, 'total' => $sum]);


    }

    private function getclientaccount_numberclient_contribution($constraints) {

        $obj= client_contribution::where('clientaccount_number', '=', $constraints['clientaccount_number']);
                        
        $sum = $obj->sum('contribution_amount');
        $client_contributions = $obj->get();
        return ['sum' => $sum, 'client_contribution' =>  $client_contributions];

    }

    private function getExportingData($constraints) {
        $obj = DB::table('client_contributions')
        ->select('client_contributions.clientaccount_number', 'client_contributions.name', 'client_contributions.contribution_month', 'client_contributions.contribution_amount', 'client_contributions.year');
        
        $obj->where('clientaccount_number', '=', $constraints['clientaccount_number']);
        $sum = $obj->sum('contribution_amount');
        $client_contributions = $obj->get();

        $client_contributions->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();

       return ['sum' => $sum, 'client_contribution' =>  $client_contributions];

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
