<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\client_contribution;
use App\Models\Employee;
use App\Models\sex;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use App\Models\Pictureupload; 
use Illuminate\Support\Facades\Storage;
use App\Models\Indivclientcont;
use Illuminate\Support\Facades\Mail;
use App\email_template\statement;
use App\Models\State;
use App\Models\Regional;



class IndivclientcontController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()

    {
        $employees = Employee::all();
        $pictureupload = Pictureupload::all();
        $regions = Regional::all();

        return view('estatementpdf/index', ['client_contribution' => null, 'searchingVals' => ['state_name' => ''], 'total' => 0, 'regions' => $regions, 'employee' => $employees, 'pictureupload' => $pictureupload ]);
    }

        public function exportPDF(Request $request) {
        // get unique record via ID Param, 
            // Thus, Append ID to the queries
            $employeesWithContributions = Employee::where('state_id','=', $request->state_id)->with('clientContributions')->get();

            $employee = Employee::all();
            $pictureupload = Pictureupload::all();

            $myHtml = ".";

        foreach($employeesWithContributions as $employee)
        {
            $view = view('estatementpdf/pdf')->with(compact('employee', $employee));
            $myHtml .= $view->render();

            $employee->email_address;
            $employee = array(
                   'firstname' => $employee->firstname,
                    'middlename' => $employee->middlename,
                     'lastname' => $employee->lastname,
                    'email_address' => $employee->email_address,
                   'staff_number' => $employee->staff_number,
            );


            $pdf = PDF::loadHTML($myHtml);


            // Mail::send('email_template/statement', $employee, function ($message) use( $employee, $pictureupload, $pdf) {

            //     $message->from('info@sic-fsl.com');
            //     $message->to($employee['email_address'])->subject('E-Statement')
            //     ->attachData($pdf->output(), 'staff_number.pdf', [
            //         'mime' => 'application/pdf',
                
            //     ]);
    
            // });

            // testing
            $emails = ["sdadzie@gmail.com"];
            Mail::send('estatementpdf/emailtesting', [], function($message) use ($emails)
            {    
                $message->from('info@sicbrokerage.com');
                $message->to($emails)->subject('This is test e-statements');
                //->attachData($pdf->output(),'e-statements_test.pdf');    
            });


      
       return response()->json(['success' => 'statements generated successfully']);
        }

          

           

        //return $pdf->download('test.pdf');       
        }
           // $employeesWithContributions = Employee::where('staff_number', '=', $request->staff_number)->get(); 

            //$employeesWithContributions = Employee::all();
        
                // dump data
                // dd($employeesWithContributions);
                // dd($employee);

            //foreach($employeesWithContributions as $emp) {
            // foreach($employee as $emp) {
            //echo $emp->firstname.' '.$emp->lastname.' '.$emp->email_address; echo '<br/>';
            //dd($emp);

                

                //$res = $this->getExportingData();
                //$client_contributions = $res['client_contribution'];
                //$sum = $res['sum'];
                /*$pdf = PDF::loadView('estatementpdf/pdf', [ 'employee' => $employeesWithContributions, 'pictureupload' => $pictureupload ]);*/

                    
                /*$path = Storage::put('public/storage/statementpdf/'.time(). 'staff_number'.'pdf', $pdf->output());
                Storage::put($path, $pdf->output());*/

                //$employee = Employee::all();
              /*  $employee = array(
                    'firstname' => $employee->firstname,
                    'middlename' => $employee->middlename,
                    'lastname' => $employee->lastname,
                    'email_address' => $employee->email_address,
                    'staff_number' => $employee->staff_number,
                );*/




           /* Mail::send('email_template/statement', $employee, function ($message) use( $employee, $pictureupload, $pdf, $path ) {

                $message->from('info@sic-fsl.com');
                $message->to($employee['email_address'])->subject('E-Statement')
                ->attachData($pdf->output(), 'staff_number.pdf', [
                    'mime' => 'application/pdf',
                
                ]);
    
            });*/
      
       // return response()->json(['success' => 'statements generated successfully']);
        
    
    public function exportPDF1(Request $request) {
        
        // query for employees with contributions based on seletected state, using state ID
        $employeesWithContributions = Employee::where('state_id','=', $request->state_id)->with('clientContributions')->get();


        // check if state exists for employee
        if(empty($employeesWithContributions) || !$employeesWithContributions){
            return response()->json(['error'=>'Please specify Region First']);
        };
  

        // iterate through the result set of employees
        foreach ($employeesWithContributions as $key => $employee) {

            

            // $employee = Employee::all();    // get & return all employee list
            $pictureupload = Pictureupload::all();  // to get picture image file

            $myHtml = ".";  // to hold/output pdf 

            $view = view('estatementpdf/pdf')->with(compact('employee', $employee));
            $myHtml .= $view->render();

            
             $pdf = PDF::loadHTML($myHtml); // load the pdf

             // testing

            $emails =  [];
            $employee = array(
                   'firstname' => $employee->firstname,
                    'middlename' => $employee->middlename,
                     'lastname' => $employee->lastname,
                    'email_address' => $employee->email_address,
                   'staff_number' => $employee->staff_number,
            );
            array_push($emails, $employee['email_address'], $employee['firstname'], $employee['middlename'], $employee['lastname'] );
            Mail::send('estatementpdf/emailtesting', $employee, function($message) use ($emails, $employee, $pdf)
            {    
                $message->from('info@sicbrokerage.com');
                $message->to($employee['email_address'])->subject('E-statements')
                ->attachData($pdf->output(),'e-statements_test.pdf');    
            });


        }
        return response()->json(['success' => 'statements generated successfully']);
        
    }

    public function search(Request $request) {
       
        $employeesWithContributions = Employee::where('state_id','=', $request->state_id)->with('clientContributions')->get();
        // $client_contributions = $res['client_contribution'];
        // $sum = $res['sum'];
        $regions = Regional::all();
        $employees = Employee::first(); 
        $pictureupload = Pictureupload::all();

        return view('estatementpdf/index')->with(['client_contribution' => $employeesWithContributions, 'searchingVals' => ['state_name' => $request->state_id], 'total' => 0, 'regions' => $regions, 'pictureupload' => $pictureupload, 'employee' => $employees]);

    }

    private function getExportingData() {
        $obj = DB::table('client_contributions')
        ->select('client_contributions.staff_no', 'client_contributions.name', 'client_contributions.contribution_month', 'client_contributions.contribution_amount', 'client_contributions.year');
        
        if (auth()->user()->state_id !== 'admin') 

        $obj->where('state_id', '=', $constraints['state_id']);
        $sum = $obj->sum('contribution_amount');
        $client_contributions = $obj->get();

        $client_contributions->map(function ($item, $key) {
        return (array) $item;
        })
        ->paginate(10)
        ->all();
        
        $Indivclientcont = Indivclientcont::all();
        $employee = Employee::all(); 
        $pictureupload = Pictureupload::all();
        $client_contribution = client_contribution::all();
       return ['sum' => $sum, 'client_contribution' =>  $client_contribution, 'employee' => $employee, 'pictureupload' => $pictureupload, 'Indivclientcont' => $Indivclientcont, 'paginate', $paginate];
       
      

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
