<?php

namespace App\Http\Controllers;

use App\Models\client_contribution;
use App\Models\csv_data;
use App\Http\Requests\CsvImportRequest;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use Auth;
use App\Models\User;

class ImportController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getImport()
    {

        $csv_data = csv_data::all();
        $csv_data = csv_data::paginate(5);
       
        return view('import/index', compact('csv_data'));
    }

    public function parseImport(CsvImportRequest $request)
    {
        
        $path = $request->file('csv_file')->getRealPath();
        if ($request->has('header')) {
            $data = Excel::load($path, function($reader) {})->get()->toArray();
        } else {
            $data = array_map('str_getcsv', file($path));
        }
        if (count($data) > 0) {
            if ($request->has('header')) {
                $csv_header_fields = [];
                foreach ($data[0] as $key => $value) {
                    $csv_header_fields[] = $key;
                }
            }
            $csv_data = array_slice($data, 0, 4000);
            $csv_data_file = csv_data::create([
                'csv_filename' => $request->file('csv_file')->getClientOriginalName(),
                'csv_header' => $request->has('header'),
                'csv_data' => json_encode($data)
            ]);
        } else {
            
        return redirect()->back();
        }
        return view('import/import_fields', compact( 'csv_header_fields', 'csv_data', 'csv_data_file'));
    }
    public function processImport(Request $request)
    {
        $data = csv_data::find($request->csv_data_file_id);
        $csv_data = json_decode($data->csv_data, true);
        foreach ($csv_data as $row) {
            $client_contribution = new client_contribution();
            foreach (config('app.db_fields') as $index => $field) {
                if ($data->csv_header) {
                    $client_contribution->$field = $row[$request->fields[$field]];
                } else {
                    $client_contribution->$field = $row[$request->fields[$index]];
                }
            }
            $client_contribution->save();
        }
        return view('import/import_success');
    }

    public function destroy($id){
        csv_data::where('id', $id)->delete();
        return redirect()->intended('import')->with('success','Record deleted');
         

    }

    public function edit(Request $request){
        
    }

    public function create(Request $request){
        $csv_data = csv_data::all();
        return view('import/create');
    }

    public function search(Request $request) {
        $constraints = [
            'csv_filename' => $request['csv_filename'],
            'csv_header' => $request['csv_header'],
            'csv_data' => $request['csv_data'],
            
            ];
        $csv_data = $this->doSearchingQuery($constraints);
        $constraints['csv_filename'];
        return view('import/index', ['csv_data' => $csv_data, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = csv_data::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where($fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    
}


