<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\identificationtype;

class IdentificationtypeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $identificationtype = identificationtype::paginate(5);

        return view('system-mgmt/identificationtype/index', ['identificationtype' => $identificationtype]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/identificationtype/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         identificationtype::create([
            'identification_type' => $request['identification_type']
        ]);

        return redirect()->intended('system-management/identificationtype');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $identificationtypes = identificationtype::find($id);
        return view('system-mgmt/identificationtype/edit', compact('identificationtypes', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       $identificationtype = identificationtype::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'identification_type' => $request['identification_type']
        ];
        identificationtype::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/identificationtype');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       identificationtype::where('id', $id)->delete();
         return redirect()->intended('system-management/identificationtype');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'identification_type' => $request['identification_type']
            ];

       $identificationtype = $this->doSearchingQuery($constraints);
       return view('system-mgmt/identificationtype/index', ['identificationtype' => $identificationtype, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = identificationtype::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'identification_type' => 'required|max:120|unique:identificationtypes'
    ]);
    }
}
