<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\client_contribution;
use App\Models\Employee;
use App\Models\sex;
use Excel;
use App\Models\fundtype;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use App\Models\fundtyperpt;
use App\Models\User;

class FundtyperptController extends Controller
{
     /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $client_contributions = $this->getstaff_noclient_contribution();
        
       $fundtype = fundtype::all();

        return view('reports/fundtyperpt-report/index', ['client_contribution' => null, 'searchingVals' => ['fundtype_name' => ''], 'total' => 0, 'fundtype' => $fundtype]);
    }

public function exportExcel(Request $request) {
        $employeesWithContributions = Employee::where('fundtype_id','=', $request->fundtype_name)->with('clientContributions')->get();
        $this->prepareExportingData($request)->export('xlsx');
        redirect()->intended('reports/fundtyperpt-report');
    }


    public function exportPDF(Request $request) {
       
        $employeesWithContributions = Employee::where('fundtype_id','=', $request->fundtype_name)->with('clientContributions')->get();


        $myHtml = ".";
        foreach($employeesWithContributions as $employee)
        {
            $view = view('reports/fundtyperpt-report/pdf')->with(compact('employee', $employee));
            $myHtml .= $view->render();
        }
        $pdf = PDF::loadHTML($myHtml);            
        //$sheet = $pdf->setPaper('a4', 'portrait');
        // return $sheet->download('download.pdf');  

        // $pdf = PDF::loadView('reports/region-report/pdf', ['employee' => $employeesWithContributions]);
    
       return $pdf->stream('fundtype_name'.'pdf');

    }

    private function prepareExportingData($request) {
        $author = Auth::user()->username;
        $employeesWithContributions = $this->getExportingData(['fundtype_id'=> $request['fundtype_name']]);
        return Excel::create('report_for_'. $request['fundtypes_id'], function($excel) use($client_contribution, $request, $author) {

        // Set the title
        $excel->setTitle('Individual Client Contributions from '. $request['state_name']);

        // Chain the setters
        $excel->setCreator($author)
            ->setCompany('Sic Brokerage Ltd');

        // Call them separately
        $excel->setDescription('Individual Client Contributions');

        $excel->sheet('Individual Client Contributions', function($sheet) use($client_contributions) {

        $sheet->fromArray($client_contribution);
            });
        });
    }

    public function search(Request $request) {
       
        $employeesWithContributions = Employee::where('fundtype_id','=', $request->fundtypes_id)->with('clientContributions')->get();
        // $client_contributions = $res['client_contribution'];
        // $sum = $res['sum'];
        $fundtype = fundtype::all();

        return view('reports/fundtyperpt-report/index')->with(['client_contribution' => $employeesWithContributions, 'searchingVals' => ['fundtype_name' => $request->fundtypes_id], 'total' => 0, 'fundtype' => $fundtype]);

    }



    private function getExportingData($constraints) {
        $obj = DB::table('client_contributions')
        ->select('client_contributions.clientaccount_number', 'client_contributions.name', 'client_contributions.contribution_month', 'client_contributions.contribution_amount', 'client_contributions.year');
        
        //if (auth()->user()->fundtypes_id !== 'admin') 

        $obj->where('fundtype_id', '=', $constraints['fundtypes_id']);
        $sum = $obj->sum('contribution_amount');
        $client_contributions = $obj->get();

        $client_contributions->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();

       return ['sum' => $sum, 'client_contribution' =>  $client_contributions];

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
