<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\studentkyc;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use App\Models\fundtype;
use App\Models\Country;
use App\Models\sex;
use App\Models\active;
use App\Models\Pictureupload;
use Carbon\Carbon;
use Response;

class FundController extends Controller
{
     /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //$employees = Employee::all();
        $sex = sex::all();
        $active = active::all();
        $fundtype = fundtype::all();
       // $department = Department::all();
       // $division = Division::all();
        //$bank = bank::all();
        $pictureupload = Pictureupload::all();
       // $state = State::all();
        $studentkyc = studentkyc::all();

       date_default_timezone_set('asia/ho_chi_minh');
        $format = '';
        $now = date($format);
        $constraints = [
            'fundtype_name' => $now,
            

        ];

        
        $studentkyc = $this->getbirthdatestudentkyc($constraints);
        return view('reports/rptfund/index', [ 'searchingVals' => $constraints, 'fundtype' => $fundtype, 'studentkyc' => $studentkyc ]);
    }

    public function exportExcel(Request $request) {
        //return $this->prepareExportingData($request);
        $this->prepareExportingData($request)->export('xlsx');
    //   echo 'everything is fine';
    //     return;
        redirect()->intended('reports/rptfund')->with('clientContributions');
    }

    public function exportPDF(Request $request) {
         $constraints = [
            'fundtype_name' => $request['fundtype_id'],
            
        ];
        $active = active::first();
        $pictureupload = Pictureupload::first();
       // $state = State::first();
        $fundtype = fundtype::first();
        
        
        $studentkyc = $this->getExportingData($constraints);
        $pdf = PDF::loadView('reports/rptfund/pdf', ['studentkyc' => $studentkyc, 'searchingVals' => $constraints, 'active' => $active, 'pictureupload' => $pictureupload, 'fundtype' => $fundtype]);

    //dd($studentkyc);
        $pdf->setPaper('A4', 'landscape');
        return $pdf->stream('report_for_'. $request['fundtype_name'].'pdf');

    }
    private function prepareExportingData($request) {
        $age = Carbon::parse($request->birthdate)->age;
        $active = active::first();
        $fundtype = fundtype::first();
        $author = Auth::user()->username;
        $studentkyc = $this->getExportingData(['fundtype_name' => $request['fundtype_id']]);

        
        return Excel::create('report_from_'. $request['fundtype_id'], function($excel) use($studentkyc, $request, $author) {

        // // Set the title
        $excel->setTitle('List of clients by' . $request['fundtype_name']);

        // // Chain the setters
        $excel->setCreator($author)
            ->setCompany('HoaDang');

        // // Call them separately
        $excel->setDescription('List of Cients By Fund Type ');

            $excel->sheet('Fundtype_studentkyc', function($sheet) use($studentkyc) {
                
                $csv= json_decode( json_encode($employees), true);
                
                $sheet->fromArray($csv);
                
            });
            
            
        });
        
    
    }
    public function search(Request $request) {
        $constraints = [
            'fundtype_name' => $request['fundtype_id'],
                    ];
                    
            $active = active::all();
            //$state = State::all();
            $fundtype = fundtype::all();

        $studentkyc = $this->getbirthdatestudentkyc($constraints);
        
        return view('reports/rptfund/index', ['studentkyc' => $studentkyc, 'searchingVals' => $constraints, 'active' => $active, 'fundtype' => $fundtype]);
    }
    private function getbirthdatestudentkyc($constraints) {
        $studentkyc = studentkyc::where('fundtype_id', '=', $constraints['fundtype_name'])
                        
                        ->get();
        return $studentkyc;
    }

    private function getExportingData($constraints) {
        return DB::table('studentkycs')
        ->leftJoin('country', 'studentkycs.country_id', '=', 'country.id')
        ->leftJoin('sexes', 'studentkycs.sex_id', '=', 'sexes.id')
        ->leftJoin('fundtypes', 'studentkycs.fundtype_id', '=', 'fundtypes.id')
        ->leftJoin('actives', 'studentkycs.active_id', '=', 'actives.id')
        ->select('studentkycs.*', 'active_type as active_type','sex_type as sex_type', 'fundtype_name as fundtype_name', 'country_name as country_name')
        
        ->where('fundtype_id', '=', $constraints['fundtype_name'])
        //->orderBy('state_name')
        ->get();
        //->groupBy('state_name')
       } 
        
    
    /**
     * Load image resource.
     *
     * @param  string  $name
     * @return \Illuminate\Http\Response
     */
    public function load($name) {
         $path = storage_path().'./app/avatars/'.$name;
        if (file_exists($path)) {
            return Response::download($path);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
