<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Fixedincometype;

class FixedincometypeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Fixedincometype = Fixedincometype::paginate(10);

        return view('asset-mgt/fixedincometype/index', ['Fixedincometype' => $Fixedincometype]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('asset-mgt/fixedincometype/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         Fixedincometype::create([
            'fixedincometype_name' => $request['fixedincometype_name']
        ]);

        return redirect()->intended('asset-mgt/fixedincometype');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Fixedincometypes = Fixedincometype::find($id);
        return view('asset-mgt/fixedincometype/edit', compact('Fixedincometypes', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Fixedincometype = Fixedincometype::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'fixedincometype_name' => $request['fixedincometype_name']
        ];
        Fixedincometype::where('id', $id)
            ->update($input);
        
        return redirect()->intended('asset-mgt/fixedincometype');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Fixedincometype::where('id', $id)->delete();
         return redirect()->intended('asset-mgt/fixedincometype');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'fixedincometype_name' => $request['fixedincometype_name']
            ];

       $Fixedincometype = $this->doSearchingQuery($constraints);
       return view('asset-mgt/fixedincometype/index', ['Fixedincometype' => $Fixedincometype, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = Fixedincometype::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'fixedincometype_name' => 'required|max:120|unique:fixedincometypes'
    ]);
    }
}
