<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Fixedincomeproduct;
use App\Models\Fixedincometype;

class FixedincomeproductController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Fixedincomeproduct = DB::table('fixedincomeproducts')
        ->leftJoin('fixedincometypes', 'fixedincomeproducts.fixedincometype_id', '=', 'fixedincometypes.id')
        ->select('fixedincomeproducts.id', 'fixedincomeproducts.fixedincomeproduct_name as fixedincomeproduct_name', 'fixedincometypes.fixedincometype_name as fixedincometype_name', 'fixedincometypes.id as fixedincometype_id')
        ->paginate(10);
        return view('asset-mgt/fixedincomeproduct/index', ['Fixedincomeproduct' => $Fixedincomeproduct]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $Fixedincometype = Fixedincometype::all();
        return view('asset-mgt/fixedincomeproduct/create', ['Fixedincometype' => $Fixedincometype]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Fixedincometype::findOrFail($request['fixedincometype_id']);
        $this->validateInput($request);
         Fixedincomeproduct::create([
            'fixedincomeproduct_name' => $request['fixedincomeproduct_name'],
            'fixedincometype_id' => $request['fixedincometype_id']
        ]);

        return redirect()->intended('asset-mgt/fixedincomeproduct');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Fixedincomeproducts = Fixedincomeproduct::find($id);
        $Fixedincometypes = Fixedincometype::all();
            return view('asset-mgt/fixedincomeproduct/edit', ['Fixedincomeproducts' => $Fixedincomeproducts, 'Fixedincometypes' => $Fixedincometypes]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Fixedincomeproduct = Fixedincomeproduct::findOrFail($id);
         $this->validate($request, [
        'fixedincomeproduct_name' => 'required|max:60'
        ]);
        $input = [
            'fixedincomeproduct_name' => $request['fixedincomeproduct_name'],
            'fixedincometype_id' => $request['fixedincometype_id']
        ];
        Fixedincomeproduct::where('id', $id)
            ->update($input);
        
        return redirect()->intended('asset-mgt/fixedincomeproduct');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Fixedincomeproduct::where('id', $id)->delete();
         return redirect()->intended('asset-mgt/fixedincomeproduct');
    }

    public function loadFixedincomeproduct($FixedincometypeId) {
        $Fixedincomeproduct = Fixedincomeproduct::where('fixedincomtype_id', '=', $FixedincometypeId)->get(['id', 'fixedincometype_name']);

        return response()->json($Fixedincomeproduct);
    }

    

    /**
     * Search state from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'fixedincomeproduct_name' => $request['fixedincomeproduct_name']
            ];

       $Fixedincomeproduct = $this->doSearchingQuery($constraints);
       return view('asset-mgt/fixedincomeproduct/index', ['Fixedincomeproduct' => $Fixedincomeproduct, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = DB::table('fixedincomeproducts')
        ->leftJoin('fixedincometypes', 'fixedincomeproducts.fixedincometype_id', '=', 'fixedincometypes.id')
        ->select('fixedincomeproducts.id', 'fixedincomeproducts.fixedincomeproduct_name as fixedincomeproduct_name', 'fixedincometypes.fixedincometype_name as fixedincometype_name', 'fixedincometypes.id as fixedincometype_id');
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'fixedincomeproduct_name' => 'required|max:60|unique:fixedincomeproducts',
        'fixedincometype_id' => 'required',
    ]);
    }
        private function createQueryInput($keys, $request) {
        $queryInput = [];
        for($i = 0; $i < sizeof($keys); $i++) {
            $key = $keys[$i];
            $queryInput[$key] = $request[$key];
        }

        return $queryInput;
    }
}
