<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Employerstatus;

class EmployerstatusController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $employerstatus = Employerstatus::paginate(5);

        return view('system-mgmt/employerstatus/index', ['employerstatus' => $employerstatus]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/employerstatus/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         Employerstatus::create([
            'employerstatus_type' => $request['employerstatus_type']
        ]);

        return redirect()->intended('system-management/employerstatus');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $employerstatuss = Employerstatus::find($id);
        return view('system-mgmt/employerstatus/edit', compact('employerstatuss', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $employerstatus = Employerstatus::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'employerstatus_type' => $request['employerstatus_type']
        ];
        Employerstatus::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/employerstatus');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Employerstatus::where('id', $id)->delete();
         return redirect()->intended('system-management/employerstatus');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'employerstatus_type' => $request['employerstatus_type']
            ];

       $employerstatus = $this->doSearchingQuery($constraints);
       return view('system-mgmt/employerstatus/index', ['employerstatus' => $employerstatus, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = Employerstatus::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'employerstatus_type' => 'required|max:120|unique:employerstatuses'
    ]);
    }
}
