<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Employerincomerange;

class EmployerincomerangeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $employerincomerange = Employerincomerange::paginate(5);

        return view('system-mgmt/employerincomerange/index', ['employerincomerange' => $employerincomerange]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       return view('system-mgmt/employerincomerange/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         Employerincomerange::create([
            'employeeincome_range' => $request['employeeincome_range']
        ]);

        return redirect()->intended('system-management/employerincomerange');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $employerincomeranges = Employerincomerange::find($id);
        return view('system-mgmt/employerincomerange/edit', compact('employerincomeranges', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $employerincomerange = Employerincomerange::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'employeeincome_range' => $request['employeeincome_range']
        ];
        Employerincomerange::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/employerincomerange');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       Employerincomerange::where('id', $id)->delete();
         return redirect()->intended('system-management/employerincomerange');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'employeeincome_range' => $request['employeeincome_range']
            ];

       $employerincomerange = $this->doSearchingQuery($constraints);
       return view('system-mgmt/employerincomerange/index', ['employerincomerange' => $employerincomerange, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = Employerincomerange::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'employeeincome_range' => 'required|max:120|unique:employerincomeranges'
    ]);
    }
}
