<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use App\Models\Employee;
use App\Models\State;
use App\Models\Country;
use App\Models\maritalstatus;
use App\Models\sex;
use App\Models\accounttype;
use App\Models\active;
use Carbon\Carbon;
use App\Models\bank;
use App\Models\investmenttframe;
use Illuminate\Support\Facades\Storage;
use App\Models\feedback;
use App\Models\identificationtype;
use App\Models\sourceoffunds;
use App\Models\residentialstatus;
use App\Models\City;
use App\Models\Statementservice;
use App\Models\Statementfrequency;
use App\Models\Employerincomerange;
use App\Models\Employerstatus;
use App\Models\fundtype;
use App\Models\title;
use App\Models\User;
use App\Models\Countryresidence;
use App\Models\risktolerance;
use App\Models\investmentknowledge;
use App\Models\modeofaccount;
use App\Models\modeofdeposite;
use App\Models\topups;
use App\Models\withdrawal;
use App\Models\studentkyc;

class EmployeeManagementController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function checkStaffId($clientNumber){
       if ( Employee::where('clientaccount_number',$clientNumber)->exists()) {
           // client number exists
            return response()->json(['status' => true]);
            // { status: true }
       }else{
        // client number does not exists
         return response()->json(['status' => false]);

       }
    }



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        $employees = DB::table('employees')
       
        ->leftJoin('country', 'employees.country_id', '=', 'country.id')
        ->leftJoin('maritalstatuses', 'employees.maritalstatus_id', '=', 'maritalstatuses.id')
        ->leftJoin('sexes', 'employees.sex_id', '=', 'sexes.id')
        ->leftJoin('accounttypes', 'employees.accounttype_id', '=', 'accounttypes.id')
        ->leftJoin('actives', 'employees.active_id', '=', 'actives.id')
        ->leftJoin('banks', 'employees.bank_id', '=', 'banks.id')
        ->leftjoin('identificationtypes', 'employees.identificationtype_id', '=', 'identificationtypes.id')
        ->leftjoin('residentialstatuses', 'employees.residentialstatus_id', '=', 'residentialstatuses.id')
        ->leftJoin('statementservices', 'employees.statementservice_id', '=', 'statementservices.id')
        ->leftJoin('statementfrequencies', 'employees.statementfrequency_id', '=', 'statementfrequencies.id')
        ->leftJoin('employerstatuses', 'employees.employerstatus_id', '=', 'employerstatuses.id')
        ->leftJoin('fundtypes', 'employees.fundtype_id', '=', 'fundtypes.id')
        ->leftJoin('employerincomeranges', 'employees.employerincomerange_id', '=', 'employerincomeranges.id')
        ->leftJoin('titles', 'employees.title_id', '=', 'titles.id')
        ->leftJoin('countryresidences', 'employees.countryresidence_id', '=', 'countryresidences.id')
        ->leftJoin('risktolerances', 'employees.risktolerance_id', '=', 'risktolerances.id')
        ->leftJoin('investmenttframes', 'employees.investmenttframe_id', '=', 'investmenttframes.id')
        ->leftJoin('investmentknowledges', 'employees.investmentknowledge_id', '=', 'investmentknowledges.id')
        ->leftJoin('modeofaccounts', 'employees.modeofaccount_id', '=', 'modeofaccounts.id')
        ->leftJoin('sourceoffunds', 'employees.sourceoffunds_id', '=', 'sourceoffunds.id')
        ->leftJoin('modeofdeposites', 'employees.modeofdeposite_id', '=', 'modeofdeposites.id')
        ->leftJoin('topups', 'employees.topups_id', '=', 'topups.id')
        ->leftJoin('withdrawals', 'employees.withdrawal_id', '=', 'withdrawals.id')
        ->leftjoin('users', 'employees.user_id', '=', 'users.id')
        ->select('employees.*', 'maritalstatus_type as maritalstatus_type', 'maritalstatuses.id as maritalstatus_id', 'active_type as active_type', 'actives.id as active_id','sex_type as sex_type', 'sexes.id as sex_id', 'account_type as account_type', 'accounttypes.id as accounttype_id', 'country_name as country_name', 'country.id as country_id', 'bank_name as bank_name', 'banks.id as bank_id', 'identification_type as identification_type', 'identificationtypes.id as identificationtype_id', 'residential_type as residential_type', 'residentialstatuses.id as residentialstatus_id', 'statementservice_type as statementservice_type', 'statementservices.id as statementservice_id', 'fundtype_name as fundtype_name', 'fundtypes.id as fundtype_id', 'title_name as title_name', 'titles.id as title_id', 'statementfrequency_type as statementfrequency_type', 'statementfrequencies.id as statementfrequency_id', 'employerstatus_type as employerstatus_type', 'employerstatuses.id as employerstatus_id', 'employeeincome_range as employeeincome_range', 'employerincomeranges.id as employerincomerange_id', 'countryresidence as countryresidence', 'countryresidences.id as countryresidence_id', 'risktolerance as risktolerance', 'risktolerances.id as risktolerance_id', 'investmenttframe_type as investmenttframe_type', 'investmenttframes.id as investmenttframe_id', 'investmentknowledge as investmentknowledge', 'investmentknowledges.id as investmentknowledge_id', 'modeofaccount as modeofaccount', 'modeofaccounts.id as modeofaccount_id', 'source_type as source_type', 'sourceoffunds.id as sourceoffunds_id', 'modeofdeposite as modeofdeposite', 'modeofdeposites.id as modeofdeposite_id', 'topup as topup', 'topups.id as topups_id', 'withdrawal as withdrawal', 'withdrawals.id as withdrawal_id', 'users.id as user_id')
        ->orderBy('active_type', 'desc')
        ->orderBy('created_at', 'asc')
        ->paginate(10);


        return view('employees-mgmt/index', ['employees' => $employees]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
{
    $user = auth()->user();

    // If the user is admin, fetch all users' forms
    if ($user->user_type == 'admin') {
        $employees = Employee::all();
    } else {
        // If the user is not admin, fetch only their own forms
        $employees = $user->employee;
    }

    $countries = Country::all();
    $maritalstatus = maritalstatus::all();
    $sex = sex::all();
    $accounttype = accounttype::all();
    $active = active::all();
    $bank = bank::all();
    $identificationtype = identificationtype::all();
    $residentialstatus = residentialstatus::all();
    $statementservice = Statementservice::all();
    $statementfrequency = Statementfrequency::all();
    $fundtype = fundtype::all();
    $employerstatus = Employerstatus::all();
    $employerincomerange = Employerincomerange::all();
    $title = title::all();
    $countryresidence = Countryresidence::all();
    $risktolerance = risktolerance::all();
    $investmenttframe = investmenttframe::all();
    $investmentknowledge = investmentknowledge::all();
    $modeofaccount = modeofaccount::all();
    $sourceoffunds = sourceoffunds::all();
    $modeofdeposite = modeofdeposite::all();
    $topup = topups::all();
    $withdrawal = withdrawal::all();
    
    return view('employees-mgmt/create', [
        'countries' => $countries,
        'maritalstatus' => $maritalstatus,
        'sex' => $sex,
        'accounttype' => $accounttype,
        'active' => $active,
        'bank' => $bank,
        'identificationtype' => $identificationtype,
        'residentialstatus' => $residentialstatus,
        'statementservice' => $statementservice,
        'fundtype' => $fundtype,
        'title' => $title,
        'employees' => $employees, // Pass the fetched employees to the view
        'statementfrequency' => $statementfrequency,
        'employerstatus' => $employerstatus,
        'employerincomerange' => $employerincomerange,
        'countryresidence' => $countryresidence,
        'investmenttframe' => $investmenttframe,
        'risktolerance' => $risktolerance,
        'investmentknowledge' => $investmentknowledge,
        'modeofaccount' => $modeofaccount,
        'sourceoffunds' => $sourceoffunds,
        'modeofdeposite' => $modeofdeposite,
        'topup' => $topup,
        'withdrawal' => $withdrawal
    ]);
}
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        

        //$this->validateInput($request);
       $age = Carbon::parse($request->birthdate)->age;
       $request->request->add(['age' => $age]);

        $imagePath = null;
        $imagePath1 = null;
        $imagePath2 = null;
        // Upload image

        if ($request->hasFile('passportpicture_img')) {
            $imagePath = Storage::putFile('avatars', $request->file('passportpicture_img'));
        }

        if ($request->hasFile('pictureID_img')) {
            $imagePath1 = Storage::putFile('avatars', $request->file('pictureID_img'));
        }

        if ($request->hasFile('signature_upload_img')) {
            $imagePath2 = Storage::putFile('avatars', $request->file('signature_upload_img'));
        }



        $request->merge(['passportpicture' => $imagePath ]);
        $request->merge(['pictureID' => $imagePath1]);
        $request->merge(['signature_upload' => $imagePath2]);


        $keys = ['clientaccount_number', 'passportpicture', 'pictureID', 'signature_upload', 'lastname', 'firstname', 'maidenname', 'middlename', 'fundtype_id', 'country_id', 'countryresidence_id', 'sex_id', 'accounttype_id', 'title_id', 'birthdate', 'place_of_birth', 'age', 'bank_id', 'identificationtype_id', 'maritalstatus_id', 'investmenttframe_id', 'sourceoffunds_id', 'residentialstatus_id', 'statementservice_id', 'phone_number', 'mobile_number', 'email_address_contact', 'bankaccount_name', 'bankaccount_number', 'bankbranch_name', 'identification_number', 'postal_address', 'residential_address', 'employer_name', 'employer_address', 'employment_years','employmentcurrent_years', 'employmentprevious_years', 'employerincomerange_id', 'employerstatus_id', 'statementfrequency_id', 'other_statementfrequency', 'residential_permit', 'permit_issue_date', 'place_of_issue_of_permit', 'permit_expiry_date', 'occupation', 'profession', 'tin', 'nearest_landmark_contact', 'digital_address_contact', 'emergency_contact_name', 'relationship_to_client', 'emergency_contact_number', 'ID_issue_date', 'ID_place_of_issue', 'ID_expiry_date', 'nearest_landmark_employer', 'digital_address_employer', 'city_town_employer', 'nature_of_business', 'phone_number_employer', 'mobile_number_employer', 'email_address_employer', 'name_of_beneficiary_1', 'relationship_1', 'contact_1', 'percentage_1', 'maritalstatus1_id', 'sex1_id', 'bndob_1', 'country1_id', 'identificationtype1_id', 'bnidentification_number_1', 'ID_issue_date_1', 'ID_place_of_issue_1', 'ID_expiry_date_1', 'name_of_beneficiary_2', 'relationship_2', 'contact_2', 'percentage_2', 'maritalstatus2_id', 'sex2_id', 'bndob_2', 'country2_id', 'identificationtype2_id', 'bnidentification_number_2', 'ID_issue_date_2', 'ID_place_of_issue_2', 'ID_expiry_date_2', 'name_of_beneficiary_3', 'relationship_3', 'contact_3', 'percentage_3', 'maritalstatus3_id', 'sex3_id', 'sex3_id', 'bndob_3', 'country3_id', 'identificationtype3_id', 'bnidentification_number_3', 'ID_issue_date_3', 'ID_place_of_issue_3', 'ID_expiry_date_3', 'name_of_beneficiary_4', 'relationship_4', 'contact_4', 'percentage_4', 'maritalstatus4_id', 'sex4_id', 'country4_id', 'bndob_4', 'identificationtype4_id', 'bnidentification_number_4', 'ID_issue_date_4', 'ID_place_of_issue_4', 'ID_expiry_date_4', 'name_of_beneficiary_5', 'relationship_5', 'contact_5', 'percentage_5', 'maritalstatus5_id', 'sex5_id', 'bndob_5', 'country5_id', 'identificationtype5_id', 'bnidentification_number_5', 'ID_issue_date_5', 'ID_place_of_issue_5', 'ID_expiry_date_5', 'investobjective', 'nameassociatedbus', 'natureassciatedbus', 'risktolerance_id', 'modeofaccount_id', 'investmentknowledge_id', 'source_of_wealth', 'other_source_fund', 'initialinvest_account', 'modeofdeposite_id', 'topups_id', 'withdrawal_id', 'regular_topup_amount', 'regular_withdrawal_amount', 'active_id'
            
        ];

// Create employee
    $employee = Employee::create($request->all());

    // Retrieve the logged-in user
    $user = auth()->user();

    // Check if the user exists and has a clientaccount_number
    if ($user && $user->clientaccount_number) {
        // Update the employee's clientaccount_number with the user's clientaccount_number
        $employee->update(['clientaccount_number' => $user->clientaccount_number]);
    }

    // Construct SMS message
        $message = "Hi".$request->firstname.",\nThank you for registering a student investment account with SIC-FSL.Your account number is ".$clientaccount_number.".Dial *789*3*658# with your account number as reference to make your initial and subsequent contributions. WhattsApp 0509541184, call 0302767051 for further info.
            \nThank you\nSIC-FSL";

        // Prepare SMS API parameters
        $key = "OE3GjyUpBzVaWOVDXRHLapjO0"; // Your API Key
        $to = $request->mobile_number; // Client's phone number
        $msg = urlencode($message); // Encode the message

        // Prepare the URL for SMS API
        $url = "https://apps.mnotify.net/smsapi?key=$key&to=$to&msg=$msg&sender_id=SIC-FSL";

        // Send the SMS
        $response = file_get_contents($url);

        // Decode response
        $decoded_response = json_decode($response);

        // Check if SMS was sent successfully
        if ($decoded_response->code == '1000') {
            echo "SMS sent"; echo "<br>";
        } else {
            echo "SMS error: " . $decoded_response->code;
        }



    // Determine the redirection based on user type
    $redirectPath = $user->user_type == 'admin' ? '/employee-management' : '/dashboard';

    // Redirect with success message
    return redirect($redirectPath)->with('success', 'Data Added Successfully');
}

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $employee = Employee::findOrFail($id);
      //  $states = State::all();
        $countries = Country::all();
        $sex = sex::all();
        $fundtype = fundtype::all();
        $active = active::all();
        $bank = bank::all();
        $feedback = feedback::all();
        $identificationtype = identificationtype::all();
        $sourceoffunds = sourceoffunds::all();
        $residentialstatus = residentialstatus::all();
      //  $citys = City::all(); 
        $statementservice = Statementservice::all();


      return view('employees-mgmt/show', ['employee' => $employee, 'countries' => $countries,
          'sex' => $sex, 'fundtype' => $fundtype, 'active' => $active, 'bank' => $bank,  'feedback' => $feedback, 'identificationtype' => $identificationtype, 'sourceoffunds' => $sourceoffunds, 'residentialstatus' => $residentialstatus, 'statementservice' =>$statementservice]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $employee = Employee::find($id);
        // Redirect to state list if updating state wasn't existed
        if ($employee == null) {
            return redirect()->intended('/employee-management');
        }
        $countries = Country::all();
    $maritalstatus = maritalstatus::all();
    $sex = sex::all();
    $accounttype = accounttype::all();
    $active = active::all();
    $bank = bank::all();
    $identificationtype = identificationtype::all();
    $residentialstatus = residentialstatus::all();
    $statementservice = Statementservice::all();
    $statementfrequency = Statementfrequency::all();
    $fundtype = fundtype::all();
    $employerstatus = Employerstatus::all();
    $employerincomerange = Employerincomerange::all();
    $title = title::all();
    $countryresidence = Countryresidence::all();
    $risktolerance = risktolerance::all();
    $investmenttframe = investmenttframe::all();
    $investmentknowledge = investmentknowledge::all();
    $modeofaccount = modeofaccount::all();
    $sourceoffunds = sourceoffunds::all();
    $modeofdeposite = modeofdeposite::all();
    $topup = topups::all();
    $withdrawal = withdrawal::all();


        return view('employees-mgmt/edit', ['employee' => $employee, 'countries' => $countries,
        'maritalstatus' => $maritalstatus,
        'sex' => $sex,
        'accounttype' => $accounttype,
        'active' => $active,
        'bank' => $bank,
        'identificationtype' => $identificationtype,
        'residentialstatus' => $residentialstatus,
        'statementservice' => $statementservice,
        'fundtype' => $fundtype,
        'title' => $title,
        'statementfrequency' => $statementfrequency,
        'employerstatus' => $employerstatus,
        'employerincomerange' => $employerincomerange,
        'countryresidence' => $countryresidence,
        'investmenttframe' => $investmenttframe,
        'risktolerance' => $risktolerance,
        'investmentknowledge' => $investmentknowledge,
        'modeofaccount' => $modeofaccount,
        'sourceoffunds' => $sourceoffunds,
        'modeofdeposite' => $modeofdeposite,
        'topup' => $topup,
        'withdrawal' => $withdrawal ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $employee = Employee::findOrFail($id);
        $this->validateInput($request);
        $age = Carbon::parse($request->birthdate)->age;
       $request->request->add(['age' => $age]);


       $imagePath = $employee->passportpicture;
       $imagePath1 = $employee->pictureID;
       $imagePath2 = $employee->signature_upload;

        if ($request->hasFile('passportpicture_img')) {
            $imagePath = Storage::putFile('avatars', $request->file('passportpicture_img'));
        }

        if ($request->hasFile('pictureID_img')) {
            $imagePath1 = Storage::putFile('avatars', $request->file('pictureID_img'));
        }

        if ($request->hasFile('signature_upload_img')) {
            $imagePath2 = Storage::putFile('avatars', $request->file('signature_upload_img'));
        }


         $request->merge([ 'passportpicture' => $imagePath ]);
        $request->merge(['pictureID' => $imagePath1]);
        $request->merge(['signature_upload' => $imagePath2]);



        // Upload image
        $keys = ['clientaccount_number', 'passportpicture', 'pictureID', 'signature_upload', 'lastname', 'firstname', 'maidenname', 'middlename', 'fundtype_id', 'country_id', 'countryresidence_id', 'sex_id', 'accounttype_id', 'title_id', 'birthdate', 'place_of_birth', 'age', 'bank_id', 'identificationtype_id', 'maritalstatus_id', 'investmenttframe_id', 'sourceoffunds_id', 'residentialstatus_id', 'statementservice_id', 'phone_number', 'mobile_number', 'email_address_contact', 'bankaccount_name', 'bankaccount_number', 'bankbranch_name', 'identification_number', 'postal_address', 'residential_address', 'employer_name', 'employer_address', 'employment_years','employmentcurrent_years', 'employmentprevious_years', 'employerincomerange_id', 'employerstatus_id', 'statementfrequency_id', 'other_statementfrequency', 'residential_permit', 'permit_issue_date', 'place_of_issue_of_permit', 'permit_expiry_date', 'occupation', 'profession', 'tin', 'nearest_landmark_contact', 'digital_address_contact', 'emergency_contact_name', 'relationship_to_client', 'emergency_contact_number', 'ID_issue_date', 'ID_place_of_issue', 'ID_expiry_date', 'nearest_landmark_employer', 'digital_address_employer', 'city_town_employer', 'nature_of_business', 'phone_number_employer', 'mobile_number_employer', 'email_address_employer', 'name_of_beneficiary_1', 'relationship_1', 'contact_1', 'percentage_1', 'maritalstatus1_id', 'sex1_id', 'bndob_1', 'country1_id', 'identificationtype1_id', 'bnidentification_number_1', 'ID_issue_date_1', 'ID_place_of_issue_1', 'ID_expiry_date_1', 'name_of_beneficiary_2', 'relationship_2', 'contact_2', 'percentage_2', 'maritalstatus2_id', 'sex2_id', 'bndob_2', 'country2_id', 'identificationtype2_id', 'bnidentification_number_2', 'ID_issue_date_2', 'ID_place_of_issue_2', 'ID_expiry_date_2', 'name_of_beneficiary_3', 'relationship_3', 'contact_3', 'percentage_3', 'maritalstatus3_id', 'sex3_id', 'sex3_id', 'bndob_3', 'country3_id', 'identificationtype3_id', 'bnidentification_number_3', 'ID_issue_date_3', 'ID_place_of_issue_3', 'ID_expiry_date_3', 'name_of_beneficiary_4', 'relationship_4', 'contact_4', 'percentage_4', 'maritalstatus4_id', 'sex4_id', 'country4_id', 'bndob_4', 'identificationtype4_id', 'bnidentification_number_4', 'ID_issue_date_4', 'ID_place_of_issue_4', 'ID_expiry_date_4', 'name_of_beneficiary_5', 'relationship_5', 'contact_5', 'percentage_5', 'maritalstatus5_id', 'sex5_id', 'bndob_5', 'country5_id', 'identificationtype5_id', 'bnidentification_number_5', 'ID_issue_date_5', 'ID_place_of_issue_5', 'ID_expiry_date_5', 'investobjective', 'nameassociatedbus', 'natureassciatedbus', 'risktolerance_id', 'modeofaccount_id', 'investmentknowledge_id', 'source_of_wealth', 'other_source_fund', 'initialinvest_account', 'modeofdeposite_id', 'topups_id', 'withdrawal_id', 'regular_topup_amount', 'regular_withdrawal_amount', 'active_id'];



        $input = $this->createQueryInput($keys, $request);


        Employee::where('id', $id)
            ->update($input);

        return redirect()->intended('/employee-management')->with('success', 'Record Updated Sucessfuly');
    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         Employee::where('id', $id)->delete();
         return redirect()->intended('/employee-management')->with('success', 'Record Deleted Sucessfuly');
    }

    /**
     * Search state from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'firstname' => $request['firstname'],
            'clientaccount_number' => $request['clientaccount_number']
            ];
        $employees = $this->doSearchingQuery($constraints);

        return view('employees-mgmt/index', ['employees' => $employees, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = DB::table('employees')
        
        ->leftJoin('country', 'employees.country_id', '=', 'country.id')
        ->leftJoin('maritalstatuses', 'employees.maritalstatus_id', '=', 'maritalstatuses.id')
        ->leftJoin('sexes', 'employees.sex_id', '=', 'sexes.id')
        ->leftJoin('accounttypes', 'employees.accounttype_id', '=', 'accounttypes.id')
        ->leftJoin('actives', 'employees.active_id', '=', 'actives.id')
        ->leftJoin('banks', 'employees.bank_id', '=', 'banks.id')
        ->leftjoin('identificationtypes', 'employees.identificationtype_id', '=', 'identificationtypes.id')
        ->leftjoin('residentialstatuses', 'employees.residentialstatus_id', '=', 'residentialstatuses.id')
        ->leftJoin('statementservices', 'employees.statementservice_id', '=', 'statementservices.id')
        ->leftJoin('statementfrequencies', 'employees.statementfrequency_id', '=', 'statementfrequencies.id')
        ->leftJoin('employerstatuses', 'employees.employerstatus_id', '=', 'employerstatuses.id')
        ->leftJoin('fundtypes', 'employees.fundtype_id', '=', 'fundtypes.id')
        ->leftJoin('employerincomeranges', 'employees.employerincomerange_id', '=', 'employerincomeranges.id')
        ->leftJoin('titles', 'employees.title_id', '=', 'titles.id')
        ->leftJoin('countryresidences', 'employees.countryresidence_id', '=', 'countryresidences.id')
        ->leftJoin('risktolerances', 'employees.risktolerance_id', '=', 'risktolerances.id')
        ->leftJoin('investmenttframes', 'employees.investmenttframe_id', '=', 'investmenttframes.id')
        ->leftJoin('investmentknowledges', 'employees.investmentknowledge_id', '=', 'investmentknowledges.id')
        ->leftJoin('modeofaccounts', 'employees.modeofaccount_id', '=', 'modeofaccounts.id')
        ->leftJoin('sourceoffunds', 'employees.sourceoffunds_id', '=', 'sourceoffunds.id')
        ->leftJoin('modeofdeposites', 'employees.modeofdeposite_id', '=', 'modeofdeposites.id')
        ->leftJoin('topups', 'employees.topups_id', '=', 'topups.id')
        ->leftJoin('withdrawals', 'employees.withdrawal_id', '=', 'withdrawals.id')
        ->leftjoin('users', 'employees.user_id', '=', 'users.id')
        ->select('employees.*', 'maritalstatus_type as maritalstatus_type', 'maritalstatuses.id as maritalstatus_id', 'active_type as active_type', 'actives.id as active_id','sex_type as sex_type', 'sexes.id as sex_id', 'account_type as account_type', 'accounttypes.id as accounttype_id', 'country_name as country_name', 'country.id as country_id', 'bank_name as bank_name', 'banks.id as bank_id', 'identification_type as identification_type', 'identificationtypes.id as identificationtype_id', 'residential_type as residential_type', 'residentialstatuses.id as residentialstatus_id', 'statementservice_type as statementservice_type', 'statementservices.id as statementservice_id', 'fundtype_name as fundtype_name', 'fundtypes.id as fundtype_id', 'title_name as title_name', 'titles.id as title_id', 'statementfrequency_type as statementfrequency_type', 'statementfrequencies.id as statementfrequency_id', 'employerstatus_type as employerstatus_type', 'employerstatuses.id as employerstatus_id', 'employeeincome_range as employeeincome_range', 'employerincomeranges.id as employerincomerange_id', 'countryresidence as countryresidence', 'countryresidences.id as countryresidence_id', 'risktolerance as risktolerance', 'risktolerances.id as risktolerance_id', 'investmenttframe_type as investmenttframe_type', 'investmenttframes.id as investmenttframe_id', 'investmentknowledge as investmentknowledge', 'investmentknowledges.id as investmentknowledge_id', 'modeofaccount as modeofaccount', 'modeofaccounts.id as modeofaccount_id', 'source_type as source_type', 'sourceoffunds.id as sourceoffunds_id', 'modeofdeposite as modeofdeposite', 'modeofdeposites.id as modeofdeposite_id', 'topup as topup', 'topups.id as topups_id', 'withdrawal as withdrawal', 'withdrawals.id as withdrawal_id', 'users.id as user_id');

        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $field => $constraint) {
    if ($constraint != null) {
        // Assuming 'firstname' belongs to the 'employees' table
        $query = $query->where('employees.' . $field, 'like', '%' . $constraint . '%');
    }
}

            $index++;
        
        return $query->paginate(100);
    }

     /**
     * Load image resource.
     *
     * @param  string  $name
     * @return \Illuminate\Http\Response
     */
    public function load($name) {
        $imagePath = storage_path().'/app/avatars/'.$name;
        if (file_exists($imagePath)) {
            return Response::download($imagePath);
        }

         $imagePath1 = storage_path().'../app/pictureID/'.$name;
        if (file_exists($imagePath1)) {
            return Response::download($imagePath1);
        }

        $imagePath2 = storage_path().'../app/signature_upload/'.$name;
        if (file_exists($imagePath1)) {
            return Response::download($imagePath1);
        }


}

   /**
     * @param Request $request
     *
     * @return string
     */

        public function approveDisapproveLeave($id, $active)
    {
       return 'here';
      $employeeId = $id;


       $employee = Employee::where('id', $employeeId)->first();

      $employee->update(['active' => $active]);

      return back()->with('success', 'Client Activated');

}


private function validateInput($request) {
        $this->validate($request, [
            'clientaccount_number' => 'nullable',
            'passportpicture' => 'nullable',
            'pictureID' => 'nullable', 
            'signature_upload' => 'nullable', 
            'lastname' => 'nullable',
            'firstname' => 'nullable', 
            'maidenname' => 'nullable', 
            'middlename' => 'nullable', 
            'fundtype_id' => 'nullable', 
            'country_id' => 'nullable', 
            //'state_id' => 'nullable', 
            'countryresidence_id' => 'nullable', 
            'sex_id' => 'nullable', 
            'accounttype_id' => 'nullable', 
            'title_id' => 'nullable', 
            'birthdate' => 'nullable', 
            'place_of_birth' => 'nullable', 
            //'mother_maiden_name' => 'nullable', 
            'age'=> 'nullable', 
            'bank_id' => 'nullable', 
            'identificationtype_id' => 'nullable', 
            'maritalstatus_id' => 'nullable', 
            'investmenttframe_id' => 'nullable', 
            'sourceoffunds_id' => 'nullable', 
            'residentialstatus_id' => 'nullable', 
            'statementservice_id' => 'nullable',  
            //'expected_annual_amount' => 'nullable', 
            'phone_number' => 'nullable', 
            'mobile_number' => 'nullable', 
            'email_address_contact' => 'nullable', 
            'bankaccount_name' => 'nullable', 
            'bankaccount_number' => 'nullable', 
            'bankbranch_name' => 'nullable', 
            'identification_number' => 'nullable', 
            'postal_address' => 'nullable', 
            'residential_address' => 'nullable', 
            'employer_name' => 'nullable', 
            'employer_address' => 'nullable', 
            'employment_years' => 'nullable',
            'employmentcurrent_years' => 'nullable', 
            'employmentprevious_years' => 'nullable', 
            'employerincomerange_id' => 'nullable', 
            'employerstatus_id' => 'nullable', 
            'statementfrequency_id' => 'nullable', 
            'other_statementfrequency' => 'nullable', 
            'residential_permit' => 'nullable', 
            'permit_issue_date' => 'nullable', 
            'place_of_issue_of_permit' => 'nullable', 
            'permit_expiry_date' => 'nullable', 
            'occupation' => 'nullable', 
            'profession' => 'nullable', 
            'tin' => 'nullable', 
            'nearest_landmark_contact' => 'nullable', 
            'digital_address_contact' => 'nullable', 
            'emergency_contact_name' => 'nullable', 
            'relationship_to_client' => 'nullable', 
            'emergency_contact_number' => 'nullable', 
            'ID_issue_date' => 'nullable', 
            'ID_place_of_issue' => 'nullable', 
            'ID_expiry_date' => 'nullable', 
            'nearest_landmark_employer' => 'nullable', 
            'digital_address_employer' => 'nullable', 
            'city_town_employer' => 'nullable', 
            'nature_of_business' => 'nullable', 
            'phone_number_employer' => 'nullable', 
            'mobile_number_employer' => 'nullable', 
            'email_address_employer' => 'nullable', 
            'name_of_beneficiary_1' => 'nullable', 
            'relationship_1' => 'nullable', 
            'contact_1' => 'nullable', 
            'percentage_1' => 'nullable', 
            'maritalstatus1_id' => 'nullable', 
            'sex1_id' => 'nullable', 
            'bndob1' => 'nullable', 
            'country1_id' => 'nullable', 
            'identificationtype1_id' => 'nullable', 
            'bnidentification_number_1' => 'nullable', 
            'ID_issue_date_1' => 'nullable', 
            'ID_place_of_issue_1' => 'nullable', 
            'ID_expiry_date_1' => 'nullable', 
            'name_of_beneficiary_2' => 'nullable', 
            'relationship_2' => 'nullable', 
            'contact_2' => 'nullable', 
            'percentage_2' => 'nullable', 
            'maritalstatus2_id' => 'nullable', 
            'sex2_id' => 'nullable', 
            'bndob2' => 'nullable', 
            'country2_id' => 'nullable', 
            'identificationtype2_id' => 'nullable', 
            'bnidentification_number_2' => 'nullable', 
            'ID_issue_date_2' => 'nullable', 
            'ID_place_of_issue_2' => 'nullable', 
            'ID_expiry_date_2' => 'nullable', 
            'name_of_beneficiary_3' => 'nullable', 
            'relationship_3' => 'nullable', 
            'contact_3' => 'nullable', 
            'percentage_3' => 'nullable', 
            'maritalstatus3_id' => 'nullable', 
            'sex3_id' => 'nullable', 
            'bndob3' => 'nullable', 
            'country3_id' => 'nullable', 
            'identificationtype3_id' => 'nullable', 
            'bnidentification_number_3' => 'nullable', 
            'ID_issue_date_3' => 'nullable', 
            'ID_place_of_issue_3' => 'nullable', 
            'ID_expiry_date_3' => 'nullable', 
            'name_of_beneficiary_4' => 'nullable', 
            'relationship_4' => 'nullable', 
            'contact_4' => 'nullable', 
            'percentage_4' => 'nullable', 
            'maritalstatus4_id' => 'nullable', 
            'sex4_id' => 'nullable', 
            'country4_id' => 'nullable', 
            'bndob4' => 'nullable', 
            'identificationtype4_id' => 'nullable', 
            'bnidentification_number_4' => 'nullable', 
            'ID_issue_date_4' => 'nullable', 
            'ID_place_of_issue_4' => 'nullable', 
            'ID_expiry_date_4' => 'nullable', 
            'name_of_beneficiary_5' => 'nullable', 
            'relationship_5' => 'nullable', 
            'contact_5' => 'nullable', 
            'percentage_5' => 'nullable', 
            'maritalstatus5_id' => 'nullable', 
            'sex5_id' => 'nullable', 
            'bndob5' => 'nullable', 
            'country5_id' => 'nullable', 
            'identificationtype5_id' => 'nullable', 
            'bnidentification_number_5' => 'nullable', 
            'ID_issue_date_5' => 'nullable', 
            'ID_place_of_issue_5' => 'nullable', 
            'ID_expiry_date_5' => 'nullable', 
            'investobjective' => 'nullable', 
            'nameassociatedbus' => 'nullable', 
            'natureassciatedbus' => 'nullable', 
            'risktolerance_id' => 'nullable', 
            'modeofaccount_id' => 'nullable', 
            'investmentknowledge_id' => 'nullable', 
            'source_of_wealth' => 'nullable', 
            'other_source_fund' => 'nullable', 
            'initialinvest_account' => 'nullable', 
            'modeofdeposite_id' => 'nullable', 
            'topups_id' => 'nullable', 
            'withdrawal_id' => 'nullable', 
            'regular_topup_amount' => 'nullable', 
            'regular_withdrawal_amount' => 'nullable', 
            'active_id' => 'nullable', 

    ]);


    }
    private function createQueryInput($keys, $request) {
        $queryInput = [];
        for($i = 0; $i < sizeof($keys); $i++) {
            $key = $keys[$i];
            $queryInput[$key] = $request[$key];
        }

        return $queryInput;
    }




  }
