<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use App\Models\Employee;
use App\Models\Fixedincometype;
use App\Models\Fixedincomeproduct;
use App\Models\client_contribution;
use App\Models\Interestratetype;
use App\Models\Interesttype;
use App\Models\interest;
use App\Models\Dailyinterestcalculator;
use App\Models\Schdulemode;
use App\Models\fundtype;
use App\Models\interestday;
use Carbon\Carbon;
use App\Models\Transaction;
use App\Models\counterparty;
use App\Models\studentkyc;

class DailyinterestcalculatorController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //$employees = Employee::all();
        $studentkyc = studentkyc::all();
    $client_contributions = client_contribution::all();
    $fundtype = fundtype::all();
    $Fixedincometype = Fixedincometype::all();
    $Fixedincomeproduct = Fixedincomeproduct::all();
    $interestday = interestday::all();
    $Interesttype = Interesttype::all();
    $Interestratetype = Interestratetype::all();
    $Transaction = Transaction::all();
    $counterparty = counterparty::all();
        $Dailyinterestcalculator = DB::table('dailyinterestcalculators')
        ->leftJoin('fixedincometypes', 'dailyinterestcalculators.fixedincometype_id', '=', 'fixedincometypes.id')
        ->leftJoin('fixedincomeproducts', 'dailyinterestcalculators.fixedincomeproduct_id', '=', 'fixedincomeproducts.id')
        ->leftJoin('interestratetypes', 'dailyinterestcalculators.interestratetype_id', '=', 'interestratetypes.id')
        ->leftJoin('interesttypes', 'dailyinterestcalculators.interesttype_id', '=', 'interesttypes.id')
        ->leftJoin('interests', 'dailyinterestcalculators.interest_id', '=', 'interests.id')
        ->leftjoin('fundtypes', 'dailyinterestcalculators.fundtype_id', '=', 'fundtypes.id')
        ->leftjoin('schedulemodes', 'dailyinterestcalculators.schedulemode_id', '=', 'schedulemodes.id')
        ->leftJoin('interestdays', 'dailyinterestcalculators.interestdaybasis_id', '=', 'interestdays.id')
        ->leftJoin('transactions', 'dailyinterestcalculators.transaction_id', '=', 'transactions.id')
        ->leftJoin('counterparties', 'dailyinterestcalculators.counterparty_id', '=', 'counterparties.id')
        ->select('dailyinterestcalculators.*', 'fixedincometypes.fixedincometype_name as fixedincometype_name', 'fixedincometypes.id as fixedincometype_id', 
            'fixedincomeproducts.fixedincomeproduct_name as fixedincomeproduct_name', 'fixedincomeproducts.id as fixedincomeproduct_id', 
            'interestratetypes.interestratetype as interestratetype', 'interestratetypes.id as interestratetype_id', 'interests.interest_amount as interest_amount', 'interests.id as interests_id', 'fundtypes.fundtype_name as fundtype_name', 'fundtypes.id as fundtype_id', 'schedulemodes.schedule_mode as schedule_mode', 'schedulemodes.id as schedulemode_id', 'interesttypes.interesttype as interesttype', 'interesttypes.id as interesttype_id', 'interestdays.interestdaybasis as interestdaybasis', 'interestdays.id as interestdaybasis_id', 'transactions.transaction_type as transaction_type', 'transactions.id as transaction_id',
            'counterparties.counterparty as counterparty', 'counterparties.id as counterparty_id')
        ->paginate(20);


        //return  ['Retirement_death' => $Retirement_death];

        return view('dailyinterestcal.index', compact('Dailyinterestcalculator', 'studentkyc', 'client_contributions', 'fundtype', 'Fixedincometype', 'Fixedincomeproduct', 'interestday', 'Interesttype', 'Interestratetype', 'Transaction', 'counterparty'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $Transaction = Transaction::all();
        $Dailyinterestcalculator = Dailyinterestcalculator::all();

        
        return view('dailyinterestcal/create',['Transaction' => $Transaction]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
{
    // Validate request data as needed

    // Implement your logic to store data in the database

        $investmentstart_date = $request->investmentstart_date;
        $investmentend_date = $request->investmentend_date;


        // diff btn dates

        
       $number_of_days_run = Carbon::parse($investmentstart_date)->diffInDaysFiltered(function(Carbon $date) {
            return $date->subDay();
         }, $investmentend_date);


       
        // loop through all the selected users
        $membersArray = $request->agree ?? [];
        foreach($membersArray as $clientaccountNo){

           // Get the contribution of from the contribution table by the clientaccountNo
            // this return the row of the given staff [name, contribution_amount, ]

            // $contributionRow = client_contribution::where('staff_no', '=', $staffNo)->first();
         
$contributionRow = client_contribution::where('clientaccount_number','=', $clientaccountNo)
            ->where('contribution_month', '=', $request->intMonth)
            ->where('year', '=', $request->intYear)
            ->select('contribution_month as month', 'contribution_amount as amount', 'clientaccount_number', 'name', 'year')
            ->get();
    

            // dd($contributionRow);

           // $tbillsRecord = tbillsint::find($request->tbillsint_id);

           /* $interest_accrued = $request->tbills*$contributionRow[0]->amount*$tbillsRecord->tbillsint_amount * $tbillsRecord->tbillsint_amount/$tbillsRecord->tbillsint_amount ;*/
$Transaction = Transaction::find($request->transaction_id);

$interestonmaturity_amount = $request->annualint_rate*$contributionRow[0]->amount*1;



        $maturityvalue_amount = $interestonmaturity_amount+$contributionRow[0]->amount;

        $total_maturity_amount = $contributionRow[0]->amount * (1 + ($request->annualint_rate * $request->tenor));

       // $maturity_days = $maturity_days;
    

        $Dailyinterestcalculator = new Dailyinterestcalculator;

        $Dailyinterestcalculator->clientaccount_number = $contributionRow[0]->clientaccount_number;
        $Dailyinterestcalculator->name = $contributionRow[0]->name;
        $Dailyinterestcalculator->incident_date = $request->incident_date;
        $Dailyinterestcalculator->contribution_amount = $contributionRow[0]->amount;
        $Dailyinterestcalculator->annualint_rate = $request->annualint_rate;
        $Dailyinterestcalculator->tenor = $request->tenor;
        $Dailyinterestcalculator->interestonmaturity_amount = $interestonmaturity_amount;
        $Dailyinterestcalculator->contribution_month= $contributionRow[0]->month;
        $Dailyinterestcalculator->year = $contributionRow[0]->year;
        $Dailyinterestcalculator->maturityvalue_amount = $maturityvalue_amount;
        $Dailyinterestcalculator->investmentstart_date =$request->investmentstart_date;
        $Dailyinterestcalculator->investmentend_date = $request->investmentend_date;
        $Dailyinterestcalculator->number_of_days_run = $number_of_days_run;
        $Dailyinterestcalculator->fixedincometype_id = $request->fixedincometype_id;
        $Dailyinterestcalculator->fixedincomeproduct_id = $request->fixedincomeproduct_id;
        $Dailyinterestcalculator->interest_id = $request->interest_id;
        $Dailyinterestcalculator->interesttype_id = $request->interesttype_id;
        $Dailyinterestcalculator->currency_id = $request->currency_id;
        $Dailyinterestcalculator->interestdaybasis_id = $request->interestdaybasis_id;
        $Dailyinterestcalculator->interestratetype_id = $request->interestratetype_id;
        $Dailyinterestcalculator->fundtype_id = $request->fundtype_id;
        $Dailyinterestcalculator->currency_id = $request->currency_id;
        //$Dailyinterestcalculator->maturity_days = $maturity_days;
        $Dailyinterestcalculator->interest_rate = $request->interest_rate;
        $Dailyinterestcalculator->total_maturity_amount = $total_maturity_amount;
        $Dailyinterestcalculator->transaction_id = $request->transaction_id;
        $Dailyinterestcalculator->narration = $request->narration;
        $Dailyinterestcalculator->counterparty_id = $request->counterparty_id;

        

        $Dailyinterestcalculator->save();

    
        $this->creditAccount($Dailyinterestcalculator['clientaccount_number'], $Dailyinterestcalculator['maturityvalue_amount']);

    


      //$totaltransaction->save();

     
}


        return redirect('dailyinterestcal')->with('success','Data Saved Successful');

    }



    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        // Retrieve the specific client contribution record by ID
    $Dailyinterestcalculators = Dailyinterestcalculator::findOrFail($id);
    
    // Retrieve other necessary data for the view
    $employees = Employee::all();
    $studentkyc = studentkyc::all();
    $fundtype = fundtype::all();
    $Fixedincometype = Fixedincometype::all();
    $Fixedincomeproduct = Fixedincomeproduct::all();
    $interestday = interestday::all();
    $Interesttype = Interesttype::all();
    $Interestratetype = Interestratetype::all();
    $Transaction = Transaction::all();
    $counterparty = counterparty::all();

    // Pass the data to the edit view
    return view('dailyinterestcal.edit', compact(
        'Dailyinterestcalculators',
        'employees', 
        'fundtype', 
        'Fixedincometype', 
        'Fixedincomeproduct', 
        'interestday', 
        'Interesttype', 
        'Interestratetype', 
        'Transaction',
        'counterparty',
        'studentkyc'
    ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // Validate request data as needed

    // Implement your logic to store data in the database

        $investmentstart_date = $request->investmentstart_date;
        $investmentend_date = $request->investmentend_date;


        // diff btn dates

        
       $number_of_days_run = Carbon::parse($investmentstart_date)->diffInDaysFiltered(function(Carbon $date) {
            return $date->subDay();
         }, $investmentend_date);


       
        // loop through all the selected users
        $membersArray = $request->agree ?? [];
        foreach($membersArray as $clientaccountNo){

           // Get the contribution of from the contribution table by the clientaccountNo
            // this return the row of the given staff [name, contribution_amount, ]

            // $Dailyinterestcalculator = Dailyinterestcalculator::where('staff_no', '=', $staffNo)->first();
         
$Dailyinterestcalculator = Dailyinterestcalculator::where('clientaccount_number','=', $clientaccountNo)->first();


    // Calculate interest on maturity
    $maturityvalue_amount = $Dailyinterestcalculator->maturityvalue_amount; // Retrieve the initial maturity value amount
    $annualint_rate = $request->annualint_rate; // Get the annual interest rate from the request
    $tenor = $request->tenor; // Get the tenor from the request

    // Calculate interest accrued for the new maturity value
    $interestonmaturity_amount = $annualint_rate * $maturityvalue_amount * 1;

    // Calculate the new maturity value amount by adding interest
    $Newmaturityvalue_amount = $interestonmaturity_amount + $maturityvalue_amount;

    // Calculate the total new maturity amount (including interest for the tenor period)
    $Newtotal_maturity_amount = $maturityvalue_amount * (1 + ($annualint_rate * $tenor));

    // Update the record
    $Dailyinterestcalculator->clientaccount_number = $request->get('clientaccount_number');
    $Dailyinterestcalculator->name = $request->get('name');
    $Dailyinterestcalculator->investmentstart_date = $investmentstart_date;
    $Dailyinterestcalculator->investmentend_date = $investmentend_date;
    $Dailyinterestcalculator->number_of_days_run = $number_of_days_run;
    $Dailyinterestcalculator->annualint_rate = $request->annualint_rate;
    $Dailyinterestcalculator->tenor = $request->tenor;
    $Dailyinterestcalculator->interestonmaturity_amount = $interestonmaturity_amount;
    $Dailyinterestcalculator->maturityvalue_amount = $Newmaturityvalue_amount;
    $Dailyinterestcalculator->total_maturity_amount = $Newtotal_maturity_amount;
    $Dailyinterestcalculator->transaction_id = $request->get('transaction_id');
    $Dailyinterestcalculator->fixedincometype_id = $request->get('fixedincometype_id');
    $Dailyinterestcalculator->fixedincomeproduct_id = $request->get('fixedincomeproduct_id');
    $Dailyinterestcalculator->interest_id = $request->get('interest_id');
    $Dailyinterestcalculator->interesttype_id = $request->get('interestratetype_id');
    $Dailyinterestcalculator->currency_id = $request->get('currency_id');
    $Dailyinterestcalculator->interestdaybasis_id = $request->get('interestdaybasis_id');
    $Dailyinterestcalculator->interestratetype_id = $request->get('interestratetype_id');
    $Dailyinterestcalculator->fundtype_id = $request->get('fundtype_id');
    $Dailyinterestcalculator->currency_id = $request->get('currency_id');
    $Dailyinterestcalculator->interest_rate = $request->get('interest_rate');
    $Dailyinterestcalculator->narration = $request->get('narration');
    $Dailyinterestcalculator->counterparty_id = $request->get('counterparty_id');

    $Dailyinterestcalculator->save();

    // Update the totalmaturities table with the current maturity value
        $this->creditAccount($Dailyinterestcalculator->clientaccount_number, $Newmaturityvalue_amount);
}

// Redirect with success message
    return redirect('dailyinterestcal')->with('success', 'Records Rollover Successful');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // Get the record to be deleted
    $transaction = Dailyinterestcalculator::find($id);
    
    if ($transaction) {
        // Deduct the maturity value amount from totalmaturities
        $clientaccount_number = $transaction->clientaccount_number;
        $maturityvalue_amount = $transaction->maturityvalue_amount;
        
        // Update the totalmaturities table
        DB::table('totalmaturities')->where('clientaccount_number', $clientaccount_number)
            ->update(['maturityvalue_amount' => DB::raw('maturityvalue_amount - '.$maturityvalue_amount)]);
        
        // Delete the transaction record
        $transaction->delete();
        
        return redirect()->intended('/dailyinterestcal')->with('success', 'Record deleted successfully and total maturity updated');
    }

    return redirect()->intended('/dailyinterestcal')->with('error', 'Record not found');
    }

    public function search(Request $request) {
    $constraints = [
        'contribution_month' => $request['contribution_month'],
        'year' => $request['year'],
        'clientaccount_number' => $request['clientaccount_number'],
    ];

    $client_contributions = $this->getmonthclient_contribution($constraints);

    $fundtype = fundtype::all();
    $interest = interest::all();
    $Fixedincometype = Fixedincometype::all();
    $Fixedincomeproduct = Fixedincomeproduct::all();
    $Interesttype = Interesttype::all();
    $interestday = interestday::all();
    $employees = Employee::all();
    $studentkyc = studentkyc::all();
    $Interestratetype = Interestratetype::all();
    $Transaction = Transaction::all();
    $counterparty = counterparty::all();

    return view('dailyinterestcal/create')->with([
        'employee' => $employees,
        'searchingVals' => $constraints,
        'fundtype' => $fundtype,
        'interest' => $interest,
        'Fixedincometype' => $Fixedincometype,
        'Fixedincomeproduct' => $Fixedincomeproduct,
        'Interesttype' => $Interesttype,
        'Interestratetype' => $Interestratetype,
        'interestday' => $interestday,
        'client_contributions' => $client_contributions,
        'Transaction' => $Transaction,
        'counterparty' => $counterparty,
        'studentkyc' => $studentkyc,
    ]);
}

private function getmonthclient_contribution($constraints) {
    $client_contributionobj = DB::table('client_contributions')
        
        ->join('studentkycs', 'client_contributions.clientaccount_number', '=', 'studentkycs.clientaccount_number')
        
         ->select('client_contributions.*', 'studentkycs.firstname', 'studentkycs.middlename', 'studentkycs.lastname')
        ->where('client_contributions.contribution_month', '=', $constraints['contribution_month'])
        ->where('client_contributions.year', '=', $constraints['year'])
        ->where('client_contributions.clientaccount_number', '=', $constraints['clientaccount_number']);

    
    $client_contribution = $client_contributionobj->get();

    return $client_contribution;
}

    private function validateInput($request) {
        $this->validate($request, [
            'clientaccount_no' => 'required',
            'name' => 'required',
            'fundtype_id' => 'required',
            'fixedincometype_id' => 'required',
            'fixedincomeproduct_id' => 'required',
            'interesttype' => 'required',
            'interestday' => 'required',
            'interests_id' => 'required',
            'incident_date' => 'required',
            'investmentstart_date' => 'required',
            'investmentend_date' => 'required',
            'maturityvalue_amount' => 'required',
            'interestonmaturity_amount' => 'required',
            'tenor' => 'required',
            'interestdaybasis_id' => 'required',
            'number_of_days_run' => 'required',
            'interestratetype_id' => 'required',
            'contribution_month' => 'required',
            'contribution_amount' => 'required',
            'year' => 'required',
            'maturity_days' => 'required',
            'interest_rate' => 'required',
            'total_maturity_amount' => 'required',
            'Transaction' => 'required',
            'counterparty_id' => 'nullable',

    ]);
    }

        private function createQueryInput($keys, $request) {
        $queryInput = [];
        for($i = 0; $i < sizeof($keys); $i++) {
            $key = $keys[$i];
            $queryInput[$key] = $request[$key];
        }

        return $queryInput;
    }

     // this will increase client total contributino on any payment made
    private function creditAccount($clientaccount_number, $newMaturityValueAmount) {
    // Fetch the existing maturity value from the totalmaturities table
    $existingRecord = DB::table('totalmaturities')->where('clientaccount_number', $clientaccount_number)->first();

    if ($existingRecord) {
        // Calculate the difference between the new maturity value and the old one
        $maturityValueDifference = $newMaturityValueAmount - $existingRecord->maturityvalue_amount;

        // Update the maturityvalue_amount by adding the difference to the current value
        DB::table('totalmaturities')->where('clientaccount_number', $clientaccount_number)->update([
            'maturityvalue_amount' => $existingRecord->maturityvalue_amount + $maturityValueDifference
        ]);
    } else {
        // Insert a new row with the clientaccount_number and new maturity value
        DB::table('totalmaturities')->insert([
            'clientaccount_number' => $clientaccount_number,
            'maturityvalue_amount' => $newMaturityValueAmount
        ]);
    }
}

}
