<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Countryresidence;
use App\Models\Pictureupload;

class CountryresidenceController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $countryresidences = Countryresidence::paginate(5);

        return view('system-mgmt/countryresidence/index', ['countryresidences' => $countryresidences]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/countryresidence/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         Countryresidence::create([
            'countryresidence' => $request['countryresidence'],
            
        ]);

        return redirect()->intended('system-management/countryresidence');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $countryresidence = Countryresidence::find($id);
        
        return view('system-mgmt/countryresidence/edit', compact('countryresidence', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $countryresidence = Countryresidence::findOrFail($id);
        $input = [
            'countryresidence' => $request['countryresidence'],
            
        ];
        $this->validate($request, [
        'countryresidence' => 'required|max:60'
        ]);
        Countryresidence::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/countryresidence');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Countryresidence::where('id', $id)->delete();
         return redirect()->intended('system-management/countryresidence');
    }

     /**
     * Search country from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'countryresidence' => $request['countryresidence'],
            
            ];

       $countryresidences = $this->doSearchingQuery($constraints);
       return view('system-mgmt/countryresidence/index', ['countryresidences' => $countryresidences, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = Countryresidence::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'countryresidence' => 'required|max:60|unique:countryresidences',
        
    ]);
    }
}


