<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\counterparty;

class CounterpartyController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $counterparty = counterparty::paginate(5);

        return view('asset-mgt/counterparty/index', ['counterparty' => $counterparty]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('asset-mgt/counterparty/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request->all());

        $this->validateInput($request);
         counterparty::create([
            'counterparty' => $request['counterparty']
        ]);

        return redirect()->intended('asset-mgt/counterparty');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $counterpartys = counterparty::find($id);
        return view('asset-mgt/counterparty/edit', compact('counterpartys', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $counterpartys = counterparty::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'counterparty' => $request['counterparty']
        ];
        counterparty::where('id', $id)
            ->update($input);
        
        return redirect()->intended('asset-mgt/counterparty')->with('success','Record update');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        counterparty::where('id', $id)->delete();
         return redirect()->intended('asset-mgt/counterparty');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'counterparty' => $request['counterparty']
            ];

       $counterparty = $this->doSearchingQuery($constraints);
       return view('asset-mgt/counterparty/index', ['counterparty' => $counterparty, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = counterparty::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'counterparty' => 'required|max:50',
    ]);
    }

}
