<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Companyprofile;

class CompanyprofileController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $companyprofile = Companyprofile::paginate(5);

        return view('system-mgmt/companyprofile/index', ['companyprofile' => $companyprofile]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/companyprofile/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         Companyprofile::create([
            'company_name' => $request['company_name'],
            'address' => $request['address'],
            'website' => $request['website'],
            'email' => $request['email'],
            'telephone' => $request['telephone'],
        ]);

        return redirect()->intended('system-management/companyprofile');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $companyprofiles = Companyprofile::find($id);
        return view('system-mgmt/companyprofile/edit', compact('companyprofiles', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $companyprofiles = Companyprofile::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'company_name' => $request['company_name'],
            'address' => $request['address'],
            'website' => $request['website'],
            'email' => $request['email'],
            'telephone' => $request['telephone'],
        ];
        Companyprofile::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/companyprofile');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       Companyprofile::where('id', $id)->delete();
         return redirect()->intended('system-management/companyprofile');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'company_name' => $request['company_name'],
            'address' => $request['address'],
            'website' => $request['website'],
            'email' => $request['email'],
            'telephone' => $request['telephone'],
            ];

       $companyprofile = $this->doSearchingQuery($constraints);
       return view('system-mgmt/companyprofile/index', ['companyprofile' => $companyprofile, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = DB::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'company_name' => 'required|max:120',
        'address' => 'required|max:500',
            'website' => 'required|max:120',
            'email' => 'required|max:120',
        'telephone' => 'nullable|max:40',
    ]);
    }
}
