<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\client_contribution;
use App\Models\Employee;
use App\Models\sex;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use App\Models\Pictureupload; 
use Illuminate\Support\Facades\Storage;
use App\Models\Indivclientcont;
use App\Models\State;
use App\Models\Regional;
use App\Models\ICSMSProviderSIC;
use Carbon\Carbon;



class ClientsmsController extends Controller
{

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $employees = Employee::all();
        $pictureupload = Pictureupload::all();
        $regions = Regional::all();

        return view('clientsms/index', ['client_contribution' => null, 'searchingVals' => ['state_name' => ''], 'total' => 0, 'regions' => $regions, 'employee' => $employees, 'pictureupload' => $pictureupload ]);
    }

    public function exportPDF2(Request $request) {
        
        // query for employees with contributions based on seletected state, using state ID
       // $employeesWithContributions = Employee::where('state_id','=', $request->state_id)->with('clientContributions')->get();

        // check if state exists for employee
       // if(empty($employeesWithContributions) || !$employeesWithContributions){
      //      return response()->json(['error'=>'Please specify Region First']);
      //  };
      //  return ICSMSProviderSIC::send('0244234015','hi world','SIC-FSL');
        
  
    }   


     public function search(Request $request) {
       
        $employeesWithContributions = Employee::where('state_id','=', $request->state_id)->with('clientContributions')->get();
        // $client_contributions = $res['client_contribution'];
        // $sum = $res['sum'];
        $regions = Regional::all();
        $employees = Employee::first(); 
        $pictureupload = Pictureupload::all();

        return view('clientsms/index')->with(['client_contribution' => $employeesWithContributions, 'searchingVals' => ['state_name' => $request->state_id], 'total' => 0, 'regions' => $regions, 'pictureupload' => $pictureupload, 'employee' => $employees]);

    }

    private function getExportingData() {
        $obj = DB::table('client_contributions')
        ->select('client_contributions.staff_no', 'client_contributions.name', 'client_contributions.contribution_month', 'client_contributions.contribution_amount', 'client_contributions.year');
        
        if (auth()->user()->state_id !== 'admin') 

        $obj->where('state_id', '=', $constraints['state_id']);
        $sum = $obj->sum('contribution_amount');
        $client_contributions = $obj->get();

        $client_contributions->map(function ($item, $key) {
        return (array) $item;
        })
        ->paginate(10)
        ->all();
        
        $Indivclientcont = Indivclientcont::all();
        $employee = Employee::all(); 
        $pictureupload = Pictureupload::all();
        $client_contribution = client_contribution::all();
       return ['sum' => $sum, 'client_contribution' =>  $client_contribution, 'employee' => $employee, 'pictureupload' => $pictureupload, 'Indivclientcont' => $Indivclientcont, 'paginate', $paginate];
       
    }

   

    public function exportPDF3(Request $request) {
      // $sumk = 0; $sumkArray = [];
        $client_contribution = client_contribution::all();
        
       
        // query for employees with contributions based on seletected state, using state ID
        $employeesWithContributions = Employee::where('state_id','=', $request->state_id)->with('clientContributions')->get();

        


        // check if state exists for employee
        if(empty($employeesWithContributions) || !$employeesWithContributions){
            return response()->json(['error'=>'Please specify Region First']);
        };
  

        // iterate through the result set of employees
        foreach ($employeesWithContributions as $key => $employee) {

             // dd($employee); return;

            // get sum from contributions
        //    $sumk = $sumk + $employee->contribution_amount;
        
       
        $sumOfContributions = 0;

        $sumOfContributions = $employee->clientContributions()->sum('contribution_amount');

       


       $latestcontribution = 0;


       
    $latestcontribution = $employee->clientContributions()->latest()->first()->contribution_amount;

     $latestmonth = $employee->clientContributions()->latest()->first()->contribution_month;
      
      



         // dd($latestmonth, $latestcontribution); return;

            $message = "Dear ".$employee->firstname." ".$employee->middlename." ".$employee->lastname.",\nYour account has been credited with ¢".$latestcontribution." for the month of ".$latestmonth.".Your total contributions is ¢".$sumOfContributions.".For further enquiries do send a mail to cohbspf@sic-fsl.com.\nThank you\nBest Regards\nSIC-FSL";

            //defining mNotify SMS API parameters
           // $key = "DvnQATCdU965f3CwDu97AQ19k";  // 0204476424 API Key
           $key = "OE3GjyUpBzVaWOVDXRHLapjO0"; // 0244234015 API Key 
            $to = $employee->mobile_number;  // phone number to send sms to
            $msg = $message;   // actual message to deliver
            $sender_id = "COHBS PF";   //sender_id: 11 mine

            //encode the message
            $msg = urlencode($msg);

            // prepare the url & endpoint
            $url = "https://apps.mnotify.net/smsapi?"
                        . "key=$key"
                        . "&to=$to"
                        . "&msg=$msg"
                        . "&sender_id=$sender_id";

            $response = file_get_contents($url);   // get message response
            echo $response; echo "<br>";

             //decode response
             $decoded_response = json_decode($response);
             if($decoded_response->code  == '1000'){
                echo "sms_sent"; echo "<br>";

                 }else{
                     echo "sms_error";
                     echo $decoded_response->code;
                }


        }
        return response()->json(['success' => 'statements generated successfully with SMS']);
        
    } 

    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
