<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Response;
use App\client_contribution;
use App\Employee;
use App\sex;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use App\Pictureupload; 
use App\User;
use App\Clientrptview;

class ClientrptviewController extends Controller
{
     /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //$Clientrptview = Clientrptview::all();

        //$user = auth()->user();

        //$Clientrptview = Employee::where('staff_number', 'staff_no', Auth::User()->staff_number)->first();

      $user = auth()->user();
      
      $employee = Employee::all();
      
        
       //return view('reports/clientrptview/index')->with('employees', $employees, ['client_contribution' => null, 'searchingVals' => ['staff_no' => ''], 'total' => 0]);
          
       return view('reports/clientrptview/index', array('user' =>Auth::user()), ['client_contribution' => null, 'searchingVals' => ['staff_no' => ''], 'total' => 0])->with(compact( 'employee', $employee));
           
    }

    public function exportPDF(Request $request) {
        $constraints = [
           'staff_no' => $request['staff_no'],
           
       ];

       
       $employee = Employee::where('staff_number', $request['staff_no'])->first();
       $pictureupload = Pictureupload::first();

 
       
       $res = $this->getExportingData($constraints);
       $client_contributions = $res['client_contribution'];
       $sum = $res['sum'];
       $pdf = PDF::loadView('reports/clientrptview/pdf', ['client_contribution' => $client_contributions, 'pictureuploads' => $pictureupload,  'searchingVals' => $constraints, 'employee' => $employee, 'total' => $sum]);
       return $pdf->stream($request['staff_no.pdf']);

    }

       public function search(Request $request) {
        $constraints = [
            'staff_no' => $request['staff_no'],
            
        ];

        $user = User::all();
        $employee = Employee::all();

        $res = $this->getstaff_noclient_contribution($constraints);
        $client_contributions = $res['client_contribution'];
        $sum = $res['sum'];

        return view('reports/clientrptview/index')->with(['client_contribution' => $client_contributions, 'searchingVals' => $constraints, 'total' => $sum, 'user' => $user, 'employee' => $employee]);


    }

    private function getstaff_noclient_contribution($constraints) {

        $employees = Employee::all();
        $user = User::all();

        $obj= client_contribution::where('staff_no', '=', $constraints['staff_no']);
                        
        $sum = $obj->sum('contribution_amount');
        $client_contributions = $obj->get();
        return ['sum' => $sum, 'client_contribution' =>  $client_contributions, 'user' => $user, 'employees' => $employees];

    }

    private function getExportingData($constraints) {
        $employees = Employee::all();
        $user = User::all();
        $obj = DB::table('client_contributions')
        ->select('client_contributions.staff_no', 'client_contributions.name', 'client_contributions.contribution_month', 'client_contributions.contribution_amount', 'client_contributions.year');
        
        $obj->where('staff_no', '=', $constraints['staff_no']);
        $sum = $obj->sum('contribution_amount');
        $client_contributions = $obj->get();

        $client_contributions->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();

       return ['sum' => $sum, 'client_contribution' =>  $client_contributions, 'user' => $user, 'employees' => $employees];

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
