<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\clientcontribution;
use App\Models\Employee;
use App\Models\User;

class ClientcontributionController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = auth()->user();
        $employee = Employee::all();
        $clientcontribution = clientcontribution::all();

        return view('clientcontribution/index', ['clientcontribution' => $clientcontribution, 'employee' => $employee]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

  $curl = curl_init();
  
  curl_setopt_array($curl, array(
    CURLOPT_URL => "https://api.paystack.co/transaction/verify/:reference",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => array(
      "Authorization: Bearer sk_test_8e02b729210d3eb82384a41b5b1353747140be1a",
      "Cache-Control: no-cache",
    ),
  ));
  
  $response = curl_exec($curl);
  $err = curl_error($curl);

  curl_close($curl);
  
  if ($err) {
    echo "cURL Error #:" . $err;
  } else {
    //echo $response;
    $result = json_decode($response);

  }

   if ($result->data->status == 'success') {
        $status = $result->data->status;
        $reference = $result->data->reference;
        $firstname = $result->data->customer->first_name;
        $lastname = $result->data->customer->last_name;
        $name = $firstname . ' ' . $lastname;
        $Cus_email = $result->data->customer->email;
        $amount = $result->data->amount;

        // Save data to the database
        $clientcontribution = clientcontribution::create([
            'status' => $status,
            'reference' => $reference,
            'firstname' => $firstname,
            'lastname' => $lastname,
            'name' => $name,
            'Cus_email' => $Cus_email,
            'amount' => $amount,
        ]);



        return response()->json(['message' => 'Payment saved successfully']);
    }
}

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function savePayment(Request $request)
    {
        $data = $request->only(['reference', 'email', 'amount']);

        // Save data to the database
        clientcontribution::create($data);

    
        return response()->json(['message' => 'Payment saved successfully']);
    }
}
