<?php

namespace App\Http\Controllers;

use App\Models\client_contribution;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\User;

class Client_contributionController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $client_contribution = client_contribution::paginate(10);

        return view('import/singlecontribution/index', ['client_contribution' => $client_contribution]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('import/singlecontribution/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         client_contribution::create([
            'clientaccount_number' => $request['clientaccount_number'],
            'name' => $request['name'],
            'contribution_amount' => $request['contribution_amount'],
            'contribution_month' => $request['contribution_month'],
            'year' => $request['year']
            
        ]);

        return redirect()->intended('import/singlecontribution');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $client_contributions = client_contribution::find($id);
        return view('import/singlecontribution/edit', compact('client_contributions', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $client_contributions = client_contribution::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'clientaccount_number' => $request['clientaccount_number'],
            'name' => $request['name'],
            'contribution_amount' => $request['contribution_amount'],
            'contribution_month' => $request['contribution_month'],
            'year' => $request['year']
        ];
        client_contribution::where('id', $id)
            ->update($input);
        
        return redirect()->intended('import/singlecontribution')->with('success', 'Record Updated Sucessfuly');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // Delete the specified contribution
    client_contribution::where('id', $id)->delete();

    // Recalculate the total contributions
    $client_contribution = client_contribution::sum('contribution_amount');

    // Redirect with the recalculated total contribution and success message
    return redirect()->intended('import/singlecontribution')
        ->with('success', 'Record deleted')
        ->with('total_contributions', $client_contribution);
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'clientaccount_number' => $request['clientaccount_number'],
            'name' => $request['name'],
            'contribution_amount' => $request['contribution_amount'],
            'contribution_month' => $request['contribution_month'],
            'year' => $request['year']
        ];

       $client_contribution = $this->doSearchingQuery($constraints);
       return view('import/singlecontribution/index', ['client_contribution' => $client_contribution, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = client_contribution::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'clientaccount_number' => 'required',
        'name' => 'required',
        'contribution_amount' => 'required',
        'contribution_month' => 'required',
        'year' => 'required'
    ]);
    }
    
}
