<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Employee;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use Response;
use App\nextofkin;


class BeneficiaryviewController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
        
        
        date_default_timezone_set('asia/ho_chi_minh');
        $format = '';
        $now = date($format);
        
        $constraints = [
            'staff_number' => $now,
            

        ];
       
        $employees = $this->getfirstnameEmployee($constraints);
        
        return view('beneficiaryview/index', ['employees' => $employees, 'searchingVals' => $constraints]);

    }
    

    public function search(Request $request) {
        $constraints = [
            'staff_number' => $request['staff_number'],
        ];

        $employees = Employees::first();

        $employees = $this->getfirstnameEmployee($constraints);
        return view('beneficiaryview/index', ['employee' => $employee, 'searchingVals' => $constraints]);

        $employees = $this->getAllEmployee($constraints);
        return view('beneficiaryview/index', ['employee' => $employee, 'searchingVals' => $constraints]);
    }

    private function getfirstnameEmployee($constraints) {
        $employees = Employee::where('employees.staff_number', '=', $constraints['staff_number'])

                        ->get();
        return $employees;

    }

    private function getExportingData($constraints) {
        return DB::table('employees')
        ->leftJoin('department', 'employees.department_id', '=', 'department.id')
        ->leftJoin('state', 'employees.state_id', '=', 'state.id')
        ->leftJoin('country', 'employees.country_id', '=', 'country.id')
        ->leftJoin('division', 'employees.division_id', '=', 'division.id')
        ->leftJoin('sexes', 'employees.sex_id', '=', 'sexes.id')
        ->leftJoin('fundtypes', 'employees.fundtype_id', '=', 'fundtypes.id')
        ->leftJoin('actives', 'employees.active_id', '=', 'actives.id')
        ->leftJoin('banks', 'employees.bank_id', '=', 'banks.id')
        ->select('employees.firstname as employee_name', 'employees.*','department.name as department_name', 'division.name as division_name', 'state_name as state_name', 'sex_type as sex_type', 'fundtype_name as fundtype_name', 'country_name as country_name', 'active_type as active_type', 'bank_name as bank_name')
        ->where('firstname', '=', $constraints['firstname'])
        ->where('staff_number', '=', $constraints['staff_number'])
        ->get()
        ->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();
        }
        
    }