<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Assetclasstype;

class AssetclasstypeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Assetclasstype = Assetclasstype::paginate(10);

        return view('asset-mgt/assetclass/index', ['Assetclasstype' => $Assetclasstype]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('asset-mgt/assetclass/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         Assetclasstype::create([
            'assetclasstype' => $request['assetclasstype']

        ]);

        return redirect()->intended('asset-mgt/assetclass');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Assetclasstypes = Assetclasstype::find($id);
       
        
        return view('asset-mgt/assetclass/edit',compact('Assetclasstypes','id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Assetclasstypes = Assetclasstype::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'assetclasstype' => $request['assetclasstype']
        ];
        Assetclasstype::where('id', $id)
            ->update($input);
        
        return redirect()->intended('asset-mgt/assetclass')->with('success','Record update');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Assetclasstype::where('id', $id)->delete();
         return redirect()->intended('asset-mgt/assetclass');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'assetclasstype' => $request['assetclasstype']
            ];

       $Assetclasstype = $this->doSearchingQuery($constraints);
       return view('asset-mgt/assetclass/index', ['Assetclasstype' => $Assetclasstype, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = Assetclasstype::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'assetclasstype' => 'required|max:60|unique:assetclasstypes'
    ]);
    }
}


