<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Assetclasstype;
use App\Assetclassname;

class AssetclassnameController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Assetclassname = DB::table('assetclassnames')
        ->leftJoin('assetclasstypes', 'assetclassnames.assetclasstype_id', '=', 'assetclasstypes.id')
        ->select('assetclassnames.id', 'assetclassnames.assetclass_name as assetclass_name', 'assetclasstypes.assetclasstype as assetclasstype', 'assetclasstypes.id as assetclasstype_id')
        ->paginate(10);
        return view('asset-mgt/assetclassname/index', ['Assetclassname' => $Assetclassname]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $Assetclasstype = Assetclasstype::all();
        return view('asset-mgt/assetclassname/create', ['Assetclasstype' => $Assetclasstype]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Assetclasstype::findOrFail($request['assetclasstype_id']);
        $this->validateInput($request);
         Assetclassname::create([
            'assetclass_name' => $request['assetclass_name'],
            'assetclasstype_id' => $request['assetclasstype_id']
        ]);

        return redirect()->intended('asset-mgt/assetclassname');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Assetclassnames = Assetclassname::find($id);
        $Assetclasstypes = Assetclasstype::all();
            return view('asset-mgt/assetclassname/edit', ['Assetclassnames' => $Assetclassnames, 'Assetclasstypes' => $Assetclasstypes]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Assetclassname = Assetclassname::findOrFail($id);
         $this->validate($request, [
        'assetclass_name' => 'required|max:60'
        ]);
        $input = [
            'assetclass_name' => $request['assetclass_name'],
            'assetclasstype_id' => $request['assetclasstype_id']
        ];
        Assetclassname::where('id', $id)
            ->update($input);
        
        return redirect()->intended('asset-mgt/assetclassname');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Assetclassname::where('id', $id)->delete();
         return redirect()->intended('asset-mgt/assetclassname');
    }

    /**
     * Search state from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'assetclass_name' => $request['assetclass_name']
            ];

       $Assetclassname = $this->doSearchingQuery($constraints);
       return view('asset-mgt/assetclassname/index', ['Assetclassname' => $Assetclassname, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = DB::table('assetclassnames')
        ->leftJoin('assetclasstypes', 'assetclassnames.assetclasstype_id', '=', 'assetclasstypes.id')
        ->select('assetclassnames.id', 'assetclassnames.assetclass_name as assetclass_name', 'assetclasstypes.assetclasstype as assetclasstype', 'assetclasstypes.id as assetclasstype_id');
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'assetclass_name' => 'required|max:60|unique:assetclassnames',
        'assetclasstype_id' => 'required',
    ]);
    }
        private function createQueryInput($keys, $request) {
        $queryInput = [];
        for($i = 0; $i < sizeof($keys); $i++) {
            $key = $keys[$i];
            $queryInput[$key] = $request[$key];
        }

        return $queryInput;
    }
}
