<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Album;


class AlbumsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    	$albums = Album::with('Photos')->get();
    	return view('albums/index')->with('albums', $albums);

    }

    public function create()
    {
    	return view('albums/create');
    }

    public function store(Request $request)
    {
    	$this->validate($request, [
    		'name' => 'required',
    		'cover_image' => 'image|max:1999'
    	]);

    	// Get filename with extension
    	$filenameWithExt = $request->file('cover_image')->getClientOriginalName();

    	//Get just the file name
    	$filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);

    	// Get extension
    	$extension = $request->file('cover_image')->getClientOriginalExtension();

    	// Create new filename
    	$filenameToStore = $filename.'_'.time().'.'.$extension;

    	// upload image
    	$path= $request->file('cover_image')->storeAs('/public/album_covers', $filenameToStore);

    	//create album
    	$album = new Album;
    	$album->name = $request->input('name');
    	$album->description = $request->input('description');
    	$album->cover_image = $filenameToStore;

    	$album->save();

    	return redirect('/albums/create')->with('success', 'Album Created');
    }

    public function show($id)
    {
    	$albums = Album::with('Photos')->find($id);
    	return view('albums/show')->with('album', $albums);
    	
    }
}