<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\accounttype;

class AccounttypeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $accounttype = accounttype::paginate(5);

        return view('system-mgmt/accounttype/index', ['accounttype' => $accounttype]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/accounttype/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         accounttype::create([
            'account_type' => $request['account_type']
        ]);

        return redirect()->intended('system-management/accounttype');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $accounttypes = accounttype::find($id);
        return view('system-mgmt/accounttype/edit', compact('accounttypes', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $accounttype = accounttype::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'account_type' => $request['account_type']
        ];
        accounttype::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/accounttype');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        accounttype::where('id', $id)->delete();
         return redirect()->intended('system-management/accounttype');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'account_type' => $request['account_type']
            ];

       $accounttype = $this->doSearchingQuery($constraints);
       return view('system-mgmt/accounttype/index', ['accounttype' => $accounttype, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = accounttype::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'account_type' => 'required|max:120|unique:accounttypes'
    ]);
    }
}
