<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Carbon\Carbon;
use App\Models\Dailyinterestcalculator;
use App\Models\client_contribution;
use Illuminate\Support\Facades\DB;

class CalculateDailyInterest extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'interest:calculate-daily';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Calculate daily interest and update maturity value';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Get all records from Dailyinterestcalculator table where number_of_days_run is greater than 0
    $dailyInterestRecords = DB::table('dailyinterestcalculators')
        ->where('number_of_days_run', '>', 0)
        ->get();

    // Loop through all records
    foreach ($dailyInterestRecords as $record) {
        // Calculate daily interest amount
        $dailyInterestAmount = ($record->annualint_rate * $record->contribution_amount * 1);

        // Calculate the new interest on maturity amount
        $newInterestOnMaturityAmount = $record->interestonmaturity_amount + $dailyInterestAmount;

        // Fetch the old maturity value before updating
        $oldMaturityValue = $record->maturityvalue_amount;

        // Update interestonmaturity_amount and maturityvalue_amount in dailyinterestcalculators table
        DB::table('dailyinterestcalculators')
            ->where('id', $record->id)
            ->update([
                'interestonmaturity_amount' => $newInterestOnMaturityAmount,
                'maturityvalue_amount' => DB::raw('maturityvalue_amount + ' . $dailyInterestAmount)
            ]);

        // Calculate the new maturity value
        $newMaturityValue = $oldMaturityValue + $dailyInterestAmount;

        // Calculate the difference between the old and new maturity values
        $difference = $newMaturityValue - $oldMaturityValue;

        // Update or insert into totalmaturities table based on the client account
        $existingMaturity = DB::table('totalmaturities')
            ->where('clientaccount_number', $record->clientaccount_number)
            ->first();

        if ($existingMaturity) {
            // Update maturityvalue_amount by adding the difference
            DB::table('totalmaturities')
                ->where('clientaccount_number', $record->clientaccount_number)
                ->update([
                    'maturityvalue_amount' => DB::raw('maturityvalue_amount + ' . $difference)
                ]);
        } else {
            // Insert a new row with the clientaccount_number and maturityvalue_amount
            DB::table('totalmaturities')
                ->insert([
                    'clientaccount_number' => $record->clientaccount_number,
                    'maturityvalue_amount' => $difference
                ]);
        }

        // Reduce number_of_days_run by 1
        DB::table('dailyinterestcalculators')
            ->where('id', $record->id)
            ->update([
                'number_of_days_run' => $record->number_of_days_run - 1
            ]);

        $this->info("Processed daily interest for account: {$record->clientaccount_number}");
    }

}

    }

